/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariant;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariantPredicate;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntityLootTables;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class EnderscapeEntityLootSubProvider
implements LootTableSubProvider {
    private final HolderLookup.Provider lookup;
    private static final Map<RubblemiteVariant, ResourceKey<LootTable>> RUBBLEMITE_BY_VARIANT = Arrays.stream(RubblemiteVariant.values()).collect(Collectors.toMap(variant -> variant, variant -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Enderscape.id("entities/rubblemite/" + variant.getSerializedName())), (a, b) -> b, () -> new EnumMap(RubblemiteVariant.class)));

    public EnderscapeEntityLootSubProvider(HolderLookup.Provider lookup) {
        this.lookup = lookup;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(this.getLootTable((EntityType)EnderscapeEntities.DRIFTER.get()), LootTable.lootTable());
        consumer.accept(this.getLootTable((EntityType)EnderscapeEntities.DRIFTLET.get()), LootTable.lootTable());
        consumer.accept(this.getLootTable((EntityType)EnderscapeEntities.RUBBLEMITE.get()), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)EnderscapeItems.RUBBLE_CHITIN.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.25f))).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(EnderscapeEntityLootSubProvider.createRubblemiteVariantPool()));
        RUBBLEMITE_BY_VARIANT.forEach((variant, key) -> consumer.accept((ResourceKey<LootTable>)key, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)variant.getDropItem()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))))));
        consumer.accept(this.getLootTable((EntityType)EnderscapeEntities.RUSTLE.get()), LootTable.lootTable());
        consumer.accept(EnderscapeEntityLootTables.SHEARING_RUSTLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STRING).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
    }

    private static LootPool.Builder createRubblemiteVariantPool() {
        AlternativesEntry.Builder builder = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
        RUBBLEMITE_BY_VARIANT.forEach((variant, lootTableKey) -> builder.otherwise(NestedLootTable.lootTableReference((ResourceKey)lootTableKey).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new RubblemiteVariantPredicate(Optional.ofNullable(variant)))))));
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder);
    }

    private ResourceKey<LootTable> getLootTable(EntityType<?> type) {
        return type.getDefaultLootTable();
    }
}

