/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.bunten.enderscape.datagen.EnderscapeBlockFamilies;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class EnderscapeRecipeProvider
extends RecipeProvider {
    public EnderscapeRecipeProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    public void buildRecipes(RecipeOutput output) {
        ImmutableList nebuliteSmeltables = ImmutableList.of((Object)((ItemLike)EnderscapeBlocks.NEBULITE_ORE.get()), (Object)((ItemLike)EnderscapeBlocks.MIRESTONE_NEBULITE_ORE.get()));
        ImmutableList shadolineSmeltables = ImmutableList.of((Object)((ItemLike)EnderscapeBlocks.SHADOLINE_ORE.get()), (Object)((ItemLike)EnderscapeBlocks.MIRESTONE_SHADOLINE_ORE.get()), (Object)((ItemLike)EnderscapeItems.RAW_SHADOLINE.get()));
        EnderscapeBlockFamilies.getAllFamilies().forEach(family -> EnderscapeRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)family, (FeatureFlagSet)FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA)));
        VanillaRecipeProvider.TrimTemplate stasisTrim = new VanillaRecipeProvider.TrimTemplate(EnderscapeItems.STASIS_ARMOR_TRIM_SMITHING_TEMPLATE.get(), ResourceLocation.fromNamespaceAndPath((String)"enderscape", (String)(EnderscapeRecipeProvider.getItemName((ItemLike)((ItemLike)EnderscapeItems.STASIS_ARMOR_TRIM_SMITHING_TEMPLATE.get())) + "_smithing_trim")));
        EnderscapeRecipeProvider.trimSmithing((RecipeOutput)output, (Item)stasisTrim.template(), (ResourceLocation)stasisTrim.id());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.MUSIC_DISC_BLISS.get())).define(Character.valueOf('D'), (ItemLike)EnderscapeItems.MUSIC_DISC_DECAY.get()).define(Character.valueOf('N'), (ItemLike)EnderscapeItems.NEBULITE_SHARDS.get()).pattern(" N ").pattern("NDN").pattern(" N ").unlockedBy("has_music_disc_decay", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.MUSIC_DISC_DECAY.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()), (int)4).requires((ItemLike)EnderscapeBlocks.DRIFT_JELLY_BLOCK.get(), 1).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy("has_drift_jelly_block", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.DRIFT_JELLY_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeBlocks.DRIFT_JELLY_BLOCK.get())).define(Character.valueOf('#'), (ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()).pattern("##").pattern("##").unlockedBy("has_drift_jelly_bottle", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)EnderscapeItems.DRIFT_LEGGINGS.get())).define(Character.valueOf('N'), (ItemLike)EnderscapeItems.NEBULITE.get()).define(Character.valueOf('D'), (ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()).pattern("NNN").pattern("D D").pattern("D D").unlockedBy("has_drift_jelly_bottle", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()))).save(output);
        this.rubbleShield(output, (ItemLike)Items.END_STONE, (ItemLike)EnderscapeItems.END_STONE_RUBBLE_SHIELD.get());
        this.rubbleShield(output, (ItemLike)EnderscapeBlocks.VERADITE.get(), (ItemLike)EnderscapeItems.VERADITE_RUBBLE_SHIELD.get());
        this.rubbleShield(output, (ItemLike)EnderscapeBlocks.MIRESTONE.get(), (ItemLike)EnderscapeItems.MIRESTONE_RUBBLE_SHIELD.get());
        this.rubbleShield(output, (ItemLike)EnderscapeBlocks.KURODITE.get(), (ItemLike)EnderscapeItems.KURODITE_RUBBLE_SHIELD.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)EnderscapeItems.MAGNIA_ATTRACTOR.get())).define(Character.valueOf('A'), (ItemLike)EnderscapeBlocks.ALLURING_MAGNIA_SPROUT.get()).define(Character.valueOf('R'), (ItemLike)EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT.get()).define(Character.valueOf('S'), (ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()).pattern("A R").pattern("SSS").pattern(" S ").unlockedBy("has_magnia_block", EnderscapeRecipeProvider.has(EnderscapeItemTags.MAGNIA_SPROUTS)).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.END_STONE_SLAB.get()), (ItemLike)Items.END_STONE, (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.END_STONE_STAIRS.get()), (ItemLike)Items.END_STONE);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.END_STONE_WALL.get()), (ItemLike)Items.END_STONE);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()), (ItemLike)Items.END_STONE);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_WALL.get()), (ItemLike)Items.END_STONE);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_SLAB.get()), (ItemLike)Items.END_STONE, (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_STAIRS.get()), (ItemLike)Items.END_STONE);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_END_STONE.get()), (ItemLike)Items.END_STONE);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.END_STONE_BRICKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.END_STONE_BRICK_SLAB, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.END_STONE_BRICK_STAIRS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.END_STONE_BRICK_WALL, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_END_STONE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_END_STONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_MIRESTONE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICKS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICKS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_MIRESTONE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_MIRESTONE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICKS.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MIRESTONE_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_VERADITE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICKS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICKS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_VERADITE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_VERADITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICKS.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.VERADITE_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_KURODITE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICKS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICKS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_KURODITE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.POLISHED_KURODITE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICKS.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.KURODITE_BRICKS.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.ETCHED_ALLURING_MAGNIA.get()), (int)4).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.ALLURING_MAGNIA.get()).pattern("##").pattern("##").unlockedBy("has_alluring_magnia", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.ALLURING_MAGNIA.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.ETCHED_REPULSIVE_MAGNIA.get()), (int)4).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.REPULSIVE_MAGNIA.get()).pattern("##").pattern("##").unlockedBy("has_repulsive_magnia", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.REPULSIVE_MAGNIA.get()))).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.ETCHED_ALLURING_MAGNIA.get()), (ItemLike)((ItemLike)EnderscapeBlocks.ALLURING_MAGNIA.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.ETCHED_REPULSIVE_MAGNIA.get()), (ItemLike)((ItemLike)EnderscapeBlocks.REPULSIVE_MAGNIA.get()));
        EnderscapeRecipeProvider.oreSmelting((RecipeOutput)output, (List)shadolineSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()), (float)0.7f, (int)200, (String)"shadoline_ingot");
        EnderscapeRecipeProvider.oreBlasting((RecipeOutput)output, (List)shadolineSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()), (float)0.7f, (int)100, (String)"shadoline_ingot");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.RAW_SHADOLINE.get()), (int)9).requires((ItemLike)EnderscapeBlocks.RAW_SHADOLINE_BLOCK.get()).group("raw_shadoline").unlockedBy("has_raw_shadoline_block", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.RAW_SHADOLINE_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.RAW_SHADOLINE_BLOCK.get())).define(Character.valueOf('#'), (ItemLike)EnderscapeItems.RAW_SHADOLINE.get()).pattern("###").pattern("###").pattern("###").group("raw_shadoline_block").unlockedBy("has_raw_shadoline", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.RAW_SHADOLINE.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()), (int)9).requires((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()).group("shadoline_ingot").unlockedBy("has_shadoline_block", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get())).define(Character.valueOf('#'), (ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()).pattern("###").pattern("###").pattern("###").group("shadoline_block").unlockedBy("has_shadoline_ingot", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()))).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_SHADOLINE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)4);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)4);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)8);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)4);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)4);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.CUT_SHADOLINE.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_PILLAR.get()), (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()), (int)4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_PILLAR.get())).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()).pattern("#").pattern("#").unlockedBy("has_shadoline_block", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.SHADOLINE_BLOCK.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.NEBULITE.get())).requires((ItemLike)EnderscapeItems.NEBULITE_SHARDS.get(), 4).unlockedBy("has_nebulite_shards", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.NEBULITE_SHARDS.get()))).save(output, "enderscape:nebulite_from_shards");
        EnderscapeRecipeProvider.oreSmelting((RecipeOutput)output, (List)nebuliteSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.NEBULITE.get()), (float)1.0f, (int)200, (String)"nebulite");
        EnderscapeRecipeProvider.oreBlasting((RecipeOutput)output, (List)nebuliteSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.NEBULITE.get()), (float)1.0f, (int)100, (String)"nebulite");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnderscapeItems.NEBULITE.get()), (int)9).requires((ItemLike)EnderscapeBlocks.NEBULITE_BLOCK.get()).group("nebulite").unlockedBy("has_nebulite_block", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.NEBULITE_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.NEBULITE_BLOCK.get())).define(Character.valueOf('#'), (ItemLike)EnderscapeItems.NEBULITE.get()).pattern("###").pattern("###").pattern("###").group("nebulite_block").unlockedBy("has_nebulite", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.NEBULITE.get()))).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_PURPUR.get()), (ItemLike)Items.PURPUR_BLOCK);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.PURPUR_WALL.get()), (ItemLike)Items.PURPUR_BLOCK);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()), (int)4).requires((ItemLike)Items.POPPED_CHORUS_FRUIT, 2).requires((ItemLike)EnderscapeItems.SHADOLINE_INGOT.get(), 2).unlockedBy("has_popped_chorus_fruit", EnderscapeRecipeProvider.has((ItemLike)Items.POPPED_CHORUS_FRUIT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_PILLAR.get())).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()).pattern("#").pattern("#").unlockedBy("has_dusk_purpur_block", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()))).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CHISELED_DUSK_PURPUR.get()), (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_PILLAR.get()), (ItemLike)((ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.PURPUR_TILES.get()), (int)4).define(Character.valueOf('P'), (ItemLike)Items.PURPUR_BLOCK).define(Character.valueOf('D'), (ItemLike)EnderscapeBlocks.DUSK_PURPUR_BLOCK.get()).pattern("DP").pattern("PD").unlockedBy("has_purpur_block", EnderscapeRecipeProvider.has((ItemLike)Items.PURPUR_BLOCK)).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.PURPUR_TILE_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.PURPUR_TILES.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.PURPUR_TILE_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.PURPUR_TILES.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)EnderscapeItems.CHORUS_CAKE_ROLL_ITEM.get())).define(Character.valueOf('C'), (ItemLike)Items.CHORUS_FRUIT).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('D'), (ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()).pattern("CCC").pattern("SDS").unlockedBy("has_chorus_fruit", EnderscapeRecipeProvider.has((ItemLike)Items.CHORUS_FRUIT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.END_LAMP.get())).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('C'), (ItemLike)Items.POPPED_CHORUS_FRUIT).pattern(" C ").pattern("CBC").pattern(" C ").unlockedBy("has_popped_chorus_fruit", EnderscapeRecipeProvider.has((ItemLike)Items.POPPED_CHORUS_FRUIT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VEILED_LEAF_PILE.get()), (int)6).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.VEILED_LEAVES.get()).pattern("###").unlockedBy("has_veiled_leaves", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.VEILED_LEAVES.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WHITE_DYE).group("white_dye").requires((ItemLike)EnderscapeBlocks.WISP_FLOWER.get(), 1).unlockedBy("has_wisp_flower", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.WISP_FLOWER.get()))).save(output, "enderscape:white_dye_from_wisp_flower");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.VEILED_PLANKS.get()), (int)4).requires(EnderscapeItemTags.VEILED_LOGS).unlockedBy("has_veiled_logs", EnderscapeRecipeProvider.has(EnderscapeItemTags.VEILED_LOGS)).save(output);
        EnderscapeRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)EnderscapeItems.VEILED_HANGING_SIGN_ITEM.get()), (ItemLike)((ItemLike)EnderscapeBlocks.STRIPPED_VEILED_LOG.get()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.YELLOW_DYE).group("yellow_dye").requires((ItemLike)EnderscapeBlocks.CELESTIAL_GROWTH.get(), 1).unlockedBy("has_celestial_growth", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_GROWTH.get()))).save(output, "enderscape:yellow_dye_from_celestial_growth");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CYAN_DYE).group("cyan_dye").requires((ItemLike)EnderscapeBlocks.BULB_FLOWER.get(), 1).unlockedBy("has_bulb_flower", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.BULB_FLOWER.get()))).save(output, "enderscape:cyan_dye_from_bulb_flower");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.BULB_LANTERN.get())).define(Character.valueOf('#'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('@'), (ItemLike)EnderscapeBlocks.BULB_FLOWER.get()).pattern("###").pattern("#@#").pattern("###").unlockedBy("has_bulb_flower", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.BULB_FLOWER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICKS.get()), (int)2).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.CELESTIAL_CAP.get()).define(Character.valueOf('@'), (ItemLike)EnderscapeBlocks.CELESTIAL_GROWTH.get()).pattern("@#").pattern("#@").unlockedBy("has_celestial_cap", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_CAP.get()))).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICKS.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_BRICKS.get()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.CELESTIAL_PLANKS.get()), (int)4).requires(EnderscapeItemTags.CELESTIAL_STEMS).unlockedBy("has_celestial_stems", EnderscapeRecipeProvider.has(EnderscapeItemTags.CELESTIAL_STEMS)).save(output);
        EnderscapeRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)EnderscapeItems.CELESTIAL_HANGING_SIGN_ITEM.get()), (ItemLike)((ItemLike)EnderscapeBlocks.STRIPPED_CELESTIAL_STEM.get()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PURPLE_DYE).group("purple_dye").requires((ItemLike)EnderscapeBlocks.CORRUPT_GROWTH.get(), 1).unlockedBy("has_corrupt_growth", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.CORRUPT_GROWTH.get()))).save(output, "enderscape:purple_dye_from_corrupt_growth");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.BLINKLAMP.get())).define(Character.valueOf('#'), (ItemLike)Items.POPPED_CHORUS_FRUIT).define(Character.valueOf('@'), (ItemLike)EnderscapeItems.BLINKLIGHT.get()).pattern("#@#").pattern("@@@").pattern("#@#").unlockedBy("has_blinklight", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.BLINKLIGHT.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICKS.get()), (int)2).define(Character.valueOf('#'), (ItemLike)EnderscapeBlocks.MURUBLIGHT_CAP.get()).define(Character.valueOf('@'), (ItemLike)EnderscapeBlocks.CORRUPT_GROWTH.get()).pattern("@#").pattern("#@").unlockedBy("has_murublight_cap", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_CAP.get()))).save(output);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICK_SLAB.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICKS.get()), (int)2);
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICK_STAIRS.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICKS.get()));
        EnderscapeRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICK_WALL.get()), (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_BRICKS.get()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnderscapeBlocks.MURUBLIGHT_PLANKS.get()), (int)4).requires(EnderscapeItemTags.MURUBLIGHT_STEMS).unlockedBy("has_murublight_stems", EnderscapeRecipeProvider.has(EnderscapeItemTags.MURUBLIGHT_STEMS)).save(output);
        EnderscapeRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)EnderscapeItems.MURUBLIGHT_HANGING_SIGN_ITEM.get()), (ItemLike)((ItemLike)EnderscapeBlocks.STRIPPED_MURUBLIGHT_STEM.get()));
    }

    protected CompletableFuture<?> run(final CachedOutput output, final HolderLookup.Provider registries) {
        final HashSet set = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.buildRecipes(new RecipeOutput(){

            public void accept(ResourceLocation location, Recipe<?> recipe, AdvancementHolder advancement, ICondition ... conditions) {
                if (!set.add(location = ResourceLocation.fromNamespaceAndPath((String)"enderscape", (String)location.getPath()))) {
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(location));
                }
                list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Recipe.CONDITIONAL_CODEC, Optional.of(new WithConditions(recipe, conditions)), (Path)EnderscapeRecipeProvider.this.recipePathProvider.json(location)));
                if (advancement != null) {
                    Advancement modifiedAdvancement = advancement.value();
                    Advancement.Builder builder = this.advancement();
                    for (Map.Entry entry : modifiedAdvancement.criteria().entrySet()) {
                        if (!((String)entry.getKey()).equals("has_the_recipe")) {
                            builder.addCriterion((String)entry.getKey(), (Criterion)entry.getValue());
                            continue;
                        }
                        builder.addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)location));
                    }
                    builder.requirements(modifiedAdvancement.requirements());
                    AdvancementRewards.Builder rewards = new AdvancementRewards.Builder();
                    rewards.addExperience(modifiedAdvancement.rewards().experience());
                    for (ResourceKey lootTable : modifiedAdvancement.rewards().loot()) {
                        rewards.addLootTable(lootTable);
                    }
                    rewards.addRecipe(location);
                    builder.rewards(rewards.build());
                    modifiedAdvancement = builder.build(advancement.id()).value();
                    list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Advancement.CONDITIONAL_CODEC, Optional.of(new WithConditions((Object)modifiedAdvancement, conditions)), (Path)EnderscapeRecipeProvider.this.advancementPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)"enderscape", (String)advancement.id().getPath()))));
                }
            }

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }
        }, registries);
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    private void rubbleShield(RecipeOutput output, ItemLike stone, ItemLike shield) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)shield).define(Character.valueOf('C'), (ItemLike)EnderscapeItems.RUBBLE_CHITIN.get()).define(Character.valueOf('S'), (ItemLike)EnderscapeItems.SHADOLINE_INGOT.get()).define(Character.valueOf('#'), stone).pattern("CSC").pattern("C#C").pattern(" C ").unlockedBy("has_rubble_chitin", EnderscapeRecipeProvider.has((ItemLike)((ItemLike)EnderscapeItems.RUBBLE_CHITIN.get()))).group("rubble_shield").save(output);
    }
}

