/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeLootTables;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class EnderscapeVaultLootSubProvider
implements LootTableSubProvider {
    private final HolderLookup.Provider lookup;

    public EnderscapeVaultLootSubProvider(HolderLookup.Provider lookup) {
        this.lookup = lookup;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(EnderscapeLootTables.END_CITY_VAULT, this.endCityVaultRewards());
        consumer.accept(EnderscapeLootTables.END_CITY_ELYTRA_VAULT, this.endCityVaultRewards().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createItem(Items.ELYTRA, 1))));
    }

    public LootTable.Builder endCityVaultRewards() {
        try {
            LootItemConditionalFunction.Builder toolDamage = SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.65f, (float)1.0f));
            EnchantWithLevelsFunction.Builder toolEnchantments = EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)30.0f, (float)50.0f));
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_SWORD, 20).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_PICKAXE, 20).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_AXE, 20).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_SHOVEL, 20).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_HOE, 20).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_HELMET, 25).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_CHESTPLATE, 25).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_LEGGINGS, 25).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND_BOOTS, 25).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_INGOT, 30).apply(this.countBetween(4, 10))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GOLD_INGOT, 30).apply(this.countBetween(2, 6))).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND, 20).apply(this.countBetween(2, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.EMERALD, 20).apply(this.countBetween(2, 6))).add((LootPoolEntryContainer.Builder)this.createItem(Items.BLAZE_ROD, 6).apply(this.countBetween(2, 4))).add((LootPoolEntryContainer.Builder)this.createItem(EnderscapeItems.NEBULITE_SHARDS.get(), 3).apply(this.countBetween(2, 12)))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(60)).add((LootPoolEntryContainer.Builder)this.createItem(Items.GOLDEN_CARROT, 40).apply(this.countBetween(1, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GOLDEN_APPLE, 10).apply(this.countBetween(1, 2))).add(this.createItem(Items.ENCHANTED_GOLDEN_APPLE, 1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(60)).add(this.createItem(EnderscapeItems.MUSIC_DISC_GLARE.get(), 6)).add(this.createItem(EnderscapeItems.MIRROR.get(), 6)).add(this.createItem(Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, 6)).add(this.createItem(EnderscapeItems.CRESCENT_BANNER_PATTERN.get(), 4)).add(this.createItem(EnderscapeItems.STASIS_ARMOR_TRIM_SMITHING_TEMPLATE.get(), 4))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(100)).add((LootPoolEntryContainer.Builder)this.createItem(Items.BOOK, 50).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withOneOf((HolderSet)HolderSet.direct((Holder[])new Holder[]{this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.PROTECTION), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.SHARPNESS), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.BANE_OF_ARTHROPODS), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.KNOCKBACK), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.LOOTING), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.EFFICIENCY), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.FORTUNE), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.UNBREAKING), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.POWER), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.PUNCH)})))).add(this.createEnchantedBook(EnderscapeEnchantments.LIGHTSPEED, 10)).add((LootPoolEntryContainer.Builder)this.createItem(Items.BOOK, 10).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withOneOf((HolderSet)HolderSet.direct((Holder[])new Holder[]{this.getEnchantmentReference(EnderscapeEnchantments.REBOUND)})))).add((LootPoolEntryContainer.Builder)this.createItem(Items.BOOK, 4).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withOneOf((HolderSet)HolderSet.direct((Holder[])new Holder[]{this.getEnchantmentReference(EnderscapeEnchantments.TRANSDIMENSIONAL), this.getEnchantmentReference((ResourceKey<Enchantment>)Enchantments.MENDING)})))));
        }
        catch (InterruptedException toolDamage) {
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @NotNull
    private LootItemConditionalFunction.Builder<?> countBetween(int f, int g) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)f, (float)g));
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createItem(Item item, int weight) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createBiomeExclusiveItem(Item item, ResourceKey<Biome> biome, int weight) throws InterruptedException, ExecutionException {
        return (LootPoolSingletonContainer.Builder)this.createItem(item, weight).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)this.lookup.lookupOrThrow(Registries.BIOME).getOrThrow(biome))));
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createEnchantedItem(Item item, int minEnchant, int maxEnchant, int weight) throws InterruptedException, ExecutionException {
        return this.createItem(item, weight).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)minEnchant, (float)maxEnchant)));
    }

    private LootPoolSingletonContainer.Builder<?> createEnchantedTrimmed(Item item, int minEnchant, int maxEnchant, ResourceKey<TrimMaterial> material, ResourceKey<TrimPattern> pattern, int weight) throws InterruptedException, ExecutionException {
        Holder.Reference materialReference = this.lookup.lookupOrThrow(Registries.TRIM_MATERIAL).getOrThrow(material);
        Holder.Reference patternReference = this.lookup.lookupOrThrow(Registries.TRIM_PATTERN).getOrThrow(pattern);
        return this.createEnchantedItem(item, minEnchant, maxEnchant, weight).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)DataComponents.TRIM, (Object)new ArmorTrim((Holder)materialReference, (Holder)patternReference)));
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createEnchantedBook(ResourceKey<Enchantment> enchantment, int weight) throws InterruptedException, ExecutionException {
        return this.createItem(Items.BOOK, weight).apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().withEnchantment(this.getEnchantmentReference(enchantment), (NumberProvider)ConstantValue.exactly((float)1.0f)));
    }

    @NotNull
    private Holder.Reference<Enchantment> getEnchantmentReference(ResourceKey<Enchantment> enchantment) throws InterruptedException, ExecutionException {
        return this.lookup.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantment);
    }
}

