/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity;

import net.bunten.enderscape.entity.DashJumpUserData;
import net.bunten.enderscape.network.ClientboundDashJumpDataPayload;
import net.bunten.enderscape.registry.EnderscapeDataAttachments;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public interface DashJumpUser {
    public static boolean is(Entity entity) {
        return entity instanceof DashJumpUser;
    }

    public static boolean dashed(Entity entity) {
        return ((DashJumpUserData)entity.getData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get())).dashed();
    }

    public static void setDashed(Entity entity, boolean value) {
        if (DashJumpUser.is(entity)) {
            DashJumpUserData existing = (DashJumpUserData)entity.getData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get());
            DashJumpUserData data = new DashJumpUserData(value, value ? existing.dashTicks() : 0);
            entity.setData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get(), (Object)data);
            if (!entity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)entity.level();
                for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(entity.chunkPosition(), false)) {
                    player.connection.send((CustomPacketPayload)new ClientboundDashJumpDataPayload(entity.getId(), data));
                }
            }
        }
    }

    public static int dashTicks(Entity entity) {
        return ((DashJumpUserData)entity.getData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get())).dashTicks();
    }

    public static void setDashTicks(Entity entity, int value) {
        if (DashJumpUser.is(entity)) {
            DashJumpUserData existing = (DashJumpUserData)entity.getData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get());
            DashJumpUserData data = new DashJumpUserData(existing.dashed(), value);
            entity.setData(EnderscapeDataAttachments.DASH_JUMP_USER_DATA.get(), (Object)data);
            if (!entity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)entity.level();
                for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(entity.chunkPosition(), false)) {
                    player.connection.send((CustomPacketPayload)new ClientboundDashJumpDataPayload(entity.getId(), data));
                }
            }
        }
    }
}

