/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity;

import net.bunten.enderscape.entity.EndTrialSpawnableData;
import net.bunten.enderscape.network.ClientboundEndTrialSpawnableDataPayload;
import net.bunten.enderscape.registry.EnderscapeDataAttachments;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public interface EndTrialSpawnable {
    public static boolean is(Entity entity) {
        return entity instanceof EndTrialSpawnable;
    }

    public static boolean spawnedFromEndTrialSpawner(Entity entity) {
        if (entity instanceof EndTrialSpawnable) {
            EndTrialSpawnable user = (EndTrialSpawnable)entity;
            return ((EndTrialSpawnableData)entity.getData(EnderscapeDataAttachments.END_TRIAL_SPAWNABLE_DATA.get())).spawnable();
        }
        return false;
    }

    public static void setSpawnedFromEndTrialSpawner(Entity entity, boolean value) {
        if (EndTrialSpawnable.is(entity)) {
            EndTrialSpawnableData data = new EndTrialSpawnableData(value);
            entity.setData(EnderscapeDataAttachments.END_TRIAL_SPAWNABLE_DATA.get(), (Object)data);
            if (!entity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)entity.level();
                for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(entity.chunkPosition(), false)) {
                    player.connection.send((CustomPacketPayload)new ClientboundEndTrialSpawnableDataPayload(entity.getId(), data));
                }
            }
        }
    }
}

