/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai;

import java.util.Optional;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class EnderscapeAI {
    public static Optional<? extends LivingEntity> getAttackTarget(LivingEntity mob) {
        Optional target = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)mob, (MemoryModuleType)EnderscapeMemory.ANGRY_AT);
        if (target.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)mob, (LivingEntity)((LivingEntity)target.get()))) {
            return target;
        }
        if (EnderscapeAI.getAttackablePlayer(mob).isPresent()) {
            return EnderscapeAI.getAttackablePlayer(mob);
        }
        return EnderscapeAI.getAttackableFrom(mob, EnderscapeMemory.NEAREST_VISIBLE_ATTACKABLE_ENEMY.get());
    }

    private static Optional<? extends LivingEntity> getAttackablePlayer(LivingEntity mob) {
        return EnderscapeAI.getAttackableFrom(mob, (MemoryModuleType<? extends LivingEntity>)EnderscapeMemory.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    private static Optional<? extends LivingEntity> getAttackableFrom(LivingEntity mob, MemoryModuleType<? extends LivingEntity> memoryType) {
        return mob.getBrain().getMemory(memoryType).filter(next -> next.closerThan((Entity)mob, 12.0));
    }
}

