/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class EnderscapeMemory
extends MemoryModuleType<Object> {
    public static final Supplier<MemoryModuleType<List<LivingEntity>>> NEAREST_ENEMIES = EnderscapeMemory.register("rubblemite_nearest_enemies");
    public static final Supplier<MemoryModuleType<LivingEntity>> NEAREST_INTIMIDATOR = EnderscapeMemory.register("drifter_nearest_intimidator");
    public static final Supplier<MemoryModuleType<LivingEntity>> NEAREST_VISIBLE_ATTACKABLE_ENEMY = EnderscapeMemory.register("rubblemite_nearest_visible_targetable_enemy");
    public static final Supplier<MemoryModuleType<LivingEntity>> NEAREST_VISIBLE_ENEMY = EnderscapeMemory.register("rubblemite_nearest_visible_enemy");
    public static final Supplier<MemoryModuleType<Integer>> DRIFTER_FIND_HOME_COOLDOWN = EnderscapeMemory.register("drifter_find_home_cooldown", Codec.INT);
    public static final Supplier<MemoryModuleType<Integer>> DRIFTER_JELLY_CHANGE_COOLDOWN = EnderscapeMemory.register("drifter_jelly_change_cooldown", Codec.INT);
    public static final Supplier<MemoryModuleType<Boolean>> RUBBLEMITE_DASH_ON_COOLDOWN = EnderscapeMemory.register("rubblemite_dash_on_cooldown", Codec.BOOL);
    public static final Supplier<MemoryModuleType<Boolean>> RUBBLEMITE_HIDING_ON_COOLDOWN = EnderscapeMemory.register("rubblemite_hiding_on_cooldown", Codec.BOOL);
    public static final Supplier<MemoryModuleType<Integer>> RUBBLEMITE_HIDING_DURATION = EnderscapeMemory.register("rubblemite_hiding_duration", Codec.INT);
    public static final Supplier<MemoryModuleType<BlockPos>> RUSTLE_FOOD = EnderscapeMemory.register("rustle_food");
    public static final Supplier<MemoryModuleType<BlockPos>> RUSTLE_SLEEPING_SPOT = EnderscapeMemory.register("rustle_sleeping_spot");
    public static final Supplier<MemoryModuleType<Boolean>> RUSTLE_SLEEPING_ON_COOLDOWN = EnderscapeMemory.register("rustle_sleeping_on_cooldown", Codec.BOOL);
    public static final Supplier<MemoryModuleType<Integer>> RUSTLE_HAIR_REGROWTH_COOLDOWN = EnderscapeMemory.register("rustle_hair_regrowth_cooldown", Codec.INT);
    public static final Supplier<MemoryModuleType<Integer>> RUSTLE_SLEEP_TICKS = EnderscapeMemory.register("rustle_sleep_ticks", Codec.INT);

    public EnderscapeMemory() {
        super(Optional.empty());
    }

    public static LivingEntity getAttackTarget(LivingEntity mob) {
        return (LivingEntity)mob.getBrain().getMemory(ATTACK_TARGET).get();
    }

    protected static <U> Supplier<MemoryModuleType<U>> register(String string, Codec<U> codec) {
        return RegistryHelper.register(BuiltInRegistries.MEMORY_MODULE_TYPE, Enderscape.id(string), () -> new MemoryModuleType(Optional.of(codec)));
    }

    protected static <U> Supplier<MemoryModuleType<U>> register(String string) {
        return RegistryHelper.register(BuiltInRegistries.MEMORY_MODULE_TYPE, Enderscape.id(string), () -> new MemoryModuleType(Optional.empty()));
    }
}

