/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CalmDownFromAttacker
extends Behavior<LivingEntity> {
    private final int distanceToForgive;

    public CalmDownFromAttacker(int distanceToForgive) {
        super((Map)ImmutableMap.of((Object)EnderscapeMemory.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_PRESENT));
        this.distanceToForgive = distanceToForgive;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity mob) {
        Optional attacker = mob.getBrain().getMemory(EnderscapeMemory.HURT_BY_ENTITY);
        return attacker.map(entity -> entity.distanceToSqr((Entity)mob) <= (double)(this.distanceToForgive * this.distanceToForgive)).orElse(false) == false;
    }

    protected void start(ServerLevel level, LivingEntity mob, long l) {
        mob.getBrain().eraseMemory(EnderscapeMemory.HURT_BY_ENTITY);
    }
}

