/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CalmDownFromIntimidator
extends Behavior<LivingEntity> {
    private final int distanceToForgive;

    public CalmDownFromIntimidator(int distanceToForgive) {
        super((Map)ImmutableMap.of(EnderscapeMemory.NEAREST_INTIMIDATOR.get(), (Object)MemoryStatus.VALUE_PRESENT));
        this.distanceToForgive = distanceToForgive;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity mob) {
        Optional intimidator = mob.getBrain().getMemory(EnderscapeMemory.NEAREST_INTIMIDATOR.get());
        return intimidator.map(entity -> entity.distanceToSqr((Entity)mob) <= (double)(this.distanceToForgive * this.distanceToForgive)).orElse(false) == false;
    }

    protected void start(ServerLevel level, LivingEntity mob, long l) {
        mob.getBrain().eraseMemory(EnderscapeMemory.NEAREST_INTIMIDATOR.get());
    }
}

