/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.entity.drifter.DrifterAI;
import net.bunten.enderscape.registry.tag.EnderscapePoiTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.phys.AABB;

public class DrifterRefreshHomePosition
extends Behavior<AbstractDrifter> {
    private static final UniformInt NEXT_COOLDOWN_RANGE = UniformInt.of((int)60, (int)120);
    private static final int MAX_HOME_SEARCH_DISTANCE = 128;
    private static final int HORIZONTAL_UPDATE_RANGE = 8;
    private static final int VERTICAL_UPDATE_RANGE = 64;

    public DrifterRefreshHomePosition() {
        super((Map)ImmutableMap.of(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected int sampleNextCooldown(AbstractDrifter mob) {
        return NEXT_COOLDOWN_RANGE.sample(mob.getRandom()) * 20;
    }

    protected void updateOtherDrifters(ServerLevel level, AbstractDrifter mob) {
        level.getEntitiesOfClass(AbstractDrifter.class, new AABB(mob.blockPosition()).inflate(8.0, 64.0, 8.0)).forEach(other -> {
            DrifterAI.setHome(other, DrifterAI.getHome(mob));
            other.getBrain().setMemory(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN.get(), (Object)this.sampleNextCooldown(mob));
        });
    }

    protected List<BlockPos> findPossibleHomes(ServerLevel level, AbstractDrifter mob) {
        Stream stream = level.getPoiManager().getInRange(holder -> holder.is(EnderscapePoiTags.DRIFTER_HOME), mob.blockPosition(), 128, PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::getPos).collect(Collectors.toList());
    }

    protected Optional<BlockPos> findNewHome(ServerLevel level, AbstractDrifter mob) {
        List<BlockPos> possibles = this.findPossibleHomes(level, mob);
        return possibles.isEmpty() ? Optional.empty() : possibles.stream().findAny();
    }

    protected void start(ServerLevel level, AbstractDrifter mob, long l) {
        Optional<BlockPos> newHome = this.findNewHome(level, mob);
        if (newHome.isPresent()) {
            DrifterAI.setHome(mob, GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)newHome.get()));
            this.updateOtherDrifters(level, mob);
        }
        mob.getBrain().setMemory(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN.get(), (Object)this.sampleNextCooldown(mob));
    }
}

