/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.entity.drifter.Drifter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class DrifterStartOrStopLeakingJelly
extends Behavior<AbstractDrifter> {
    private static final UniformInt NEXT_COOLDOWN_RANGE_IN_MINUTES = UniformInt.of((int)15, (int)20);

    public DrifterStartOrStopLeakingJelly() {
        super((Map)ImmutableMap.of(EnderscapeMemory.DRIFTER_JELLY_CHANGE_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT));
    }

    public static void refreshCooldown(Drifter mob) {
        mob.getBrain().setMemory(EnderscapeMemory.DRIFTER_JELLY_CHANGE_COOLDOWN.get(), (Object)(NEXT_COOLDOWN_RANGE_IN_MINUTES.sample(mob.getRandom()) * 20 * 60));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, AbstractDrifter mob) {
        return mob instanceof Drifter;
    }

    protected void start(ServerLevel level, AbstractDrifter mob, long l) {
        if (mob instanceof Drifter) {
            Drifter drifter;
            drifter.setDrippingJelly(!(drifter = (Drifter)mob).isDrippingJelly());
            DrifterStartOrStopLeakingJelly.refreshCooldown(drifter);
        }
    }
}

