/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DrifterWanderAround {
    private static final int HORIZONTAL_WANDER_RANGE = 12;
    private static final int VERTICAL_WANDER_RANGE = 4;
    private static final int VERTICAL_PATHFIND_BIAS = 0;

    public static BehaviorControl<PathfinderMob> create() {
        return DrifterWanderAround.create(DrifterWanderAround::getRandomPathfindTarget);
    }

    @Nullable
    private static Vec3 getRandomPathfindTarget(PathfinderMob mob) {
        Vec3 vec3 = mob.getViewVector(0.0f);
        for (int i = 0; i < 10; ++i) {
            Vec3 pos = AirAndWaterRandomPos.getPos((PathfinderMob)mob, (int)12, (int)4, (int)0, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
            if (pos == null || !(pos.y >= 0.0)) continue;
            return pos;
        }
        return null;
    }

    public static OneShot<PathfinderMob> create(Function<PathfinderMob, Vec3> randomPath) {
        return BehaviorBuilder.create((T instance) -> instance.group((App)instance.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, memory -> (level, mob, l) -> {
            boolean isHome;
            if (mob.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER)) {
                return false;
            }
            Optional<Vec3> randomPos = Optional.ofNullable((Vec3)randomPath.apply((PathfinderMob)mob));
            Optional homePos = mob.getBrain().getMemory(EnderscapeMemory.HOME);
            boolean bl = isHome = homePos.isPresent() && mob.blockPosition().distSqr((Vec3i)((GlobalPos)homePos.get()).pos()) >= 2500.0;
            if (isHome) {
                randomPos = Optional.of(((GlobalPos)homePos.get()).pos().getCenter());
            }
            memory.setOrErase(randomPos.map(pos -> new WalkTarget(pos, isHome ? 1.5f : 1.0f, 0)));
            return true;
        }));
    }
}

