/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rubblemite.Rubblemite;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class RubblemiteDashDuringCombat
extends Behavior<Rubblemite> {
    public RubblemiteDashDuringCombat() {
        super((Map)ImmutableMap.of((Object)EnderscapeMemory.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Rubblemite mob) {
        double d;
        if (mob.getFlags() == 0 && !mob.isVehicle() && mob.onGround() && !mob.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) && (d = mob.distanceToSqr((Entity)EnderscapeMemory.getAttackTarget((LivingEntity)mob))) >= 6.0 && d <= 35.0) {
            return mob.getRandom().nextInt(10) == 0;
        }
        return false;
    }

    protected void start(ServerLevel level, Rubblemite mob, long l) {
        mob.dash();
        mob.getBrain().setMemoryWithExpiry(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN.get(), (Object)true, 30L);
    }
}

