/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rustle.Rustle;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class RustleEatWhenSheared
extends Behavior<Rustle> {
    private final float speedModifier;

    public RustleEatWhenSheared(float speedModifier) {
        super((Map)ImmutableMap.of(EnderscapeMemory.RUSTLE_FOOD.get(), (Object)MemoryStatus.VALUE_PRESENT));
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Rustle mob) {
        return mob.isSheared() && mob.getRandom().nextInt(300) == 0 && mob.getBrain().getActiveNonCoreActivity().map(activity -> activity == Activity.IDLE).orElse(true) != false;
    }

    protected boolean canStillUse(ServerLevel level, Rustle mob, long time) {
        return mob.isSheared() && mob.getBrain().hasMemoryValue(EnderscapeMemory.RUSTLE_FOOD.get());
    }

    protected boolean timedOut(long l) {
        return false;
    }

    protected void tick(ServerLevel level, Rustle mob, long time) {
        BlockPos food = (BlockPos)mob.getBrain().getMemory(EnderscapeMemory.RUSTLE_FOOD.get()).get();
        if (food.closerThan((Vec3i)mob.blockPosition(), 0.5)) {
            level.destroyBlock(food, false, (Entity)mob);
            mob.playSound(EnderscapeEntitySounds.RUSTLE_EAT.get());
            Rustle.regrowHairWithParticles(level, mob);
            this.stop(level, (LivingEntity)mob, time);
        } else {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)mob, (BlockPos)food, (float)this.speedModifier, (int)0);
        }
    }
}

