/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rustle.Rustle;
import net.bunten.enderscape.entity.rustle.RustleAI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class RustleGoToSleep
extends Behavior<Rustle> {
    private final float speedModifier;

    public RustleGoToSleep(float speedModifier) {
        super((Map)ImmutableMap.of(EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get(), (Object)MemoryStatus.VALUE_PRESENT, EnderscapeMemory.RUSTLE_SLEEPING_ON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Rustle mob) {
        return mob.getBrain().getActiveNonCoreActivity().map(activity -> activity == Activity.IDLE).orElse(true);
    }

    protected boolean canStillUse(ServerLevel level, Rustle mob, long time) {
        return mob.getBrain().hasMemoryValue(EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get());
    }

    protected void tick(ServerLevel level, Rustle mob, long time) {
        BlockPos sleepingSpot = (BlockPos)mob.getBrain().getMemory(EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get()).get();
        if (sleepingSpot.closerThan((Vec3i)mob.blockPosition(), 0.05)) {
            mob.getBrain().setMemory(EnderscapeMemory.RUSTLE_SLEEP_TICKS.get(), (Object)(RustleAI.SLEEPING_TIME_RANGE_IN_MINUTES.sample(mob.getRandom()) * 60 * 20));
            this.stop(level, (LivingEntity)mob, time);
        } else {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)mob, (BlockPos)sleepingSpot, (float)this.speedModifier, (int)0);
        }
    }
}

