/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.spongepowered.include.com.google.common.collect.Lists;

public class NearestEnemiesSensor
extends Sensor<LivingEntity> {
    private final TagKey<EntityType<?>> enemies;

    public NearestEnemiesSensor(TagKey<EntityType<?>> enemies) {
        this.enemies = enemies;
    }

    protected boolean isEnemy(LivingEntity mob, LivingEntity next) {
        return next.getType().is(this.enemies) && EntitySelector.NO_SPECTATORS.test(next) && mob.closerThan((Entity)next, 16.0);
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES, EnderscapeMemory.NEAREST_ENEMIES.get(), EnderscapeMemory.NEAREST_VISIBLE_ENEMY.get());
    }

    protected void doTick(ServerLevel level, LivingEntity mob) {
        Brain brain = mob.getBrain();
        Optional<Object> nearest = Optional.empty();
        Optional<Object> nearestAttackable = Optional.empty();
        ArrayList enemies = Lists.newArrayList();
        NearestVisibleLivingEntities visible = brain.getMemory(EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (LivingEntity next2 : visible.findAll(next -> this.isEnemy(mob, (LivingEntity)next))) {
            if (nearest.isEmpty()) {
                nearest = Optional.of(next2);
            }
            if (NearestEnemiesSensor.isEntityAttackable((LivingEntity)mob, (LivingEntity)next2) && nearestAttackable.isEmpty()) {
                nearestAttackable = Optional.of(next2);
            }
            enemies.add(next2);
        }
        brain.setMemory(EnderscapeMemory.NEAREST_VISIBLE_ENEMY.get(), nearest);
        brain.setMemory(EnderscapeMemory.NEAREST_VISIBLE_ATTACKABLE_ENEMY.get(), nearestAttackable);
        brain.setMemory(EnderscapeMemory.NEAREST_ENEMIES.get(), (Object)enemies);
    }
}

