/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.registry.tag.EnderscapeEntityTags;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestIntimidatorSensor
extends Sensor<AbstractDrifter> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    protected void doTick(ServerLevel level, AbstractDrifter mob) {
        block0: {
            Brain<AbstractDrifter> brain = mob.getBrain();
            NearestVisibleLivingEntities nearby = brain.getMemory(EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
            Iterator iterator = nearby.findAll(next -> next.getType().is(EnderscapeEntityTags.DRIFTERS_INTIMIDATED_BY)).iterator();
            if (!iterator.hasNext()) break block0;
            LivingEntity next2 = (LivingEntity)iterator.next();
            brain.setMemory(EnderscapeMemory.NEAREST_INTIMIDATOR.get(), (Object)next2);
        }
    }
}

