/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.drifter;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import net.bunten.enderscape.entity.drifter.DrifterAI;
import net.bunten.enderscape.entity.drifter.Driftlet;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractDrifter
extends Animal {
    public AbstractDrifter(EntityType<? extends AbstractDrifter> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
    }

    protected static AttributeSupplier.Builder createBaseDrifterAttributes() {
        return AbstractDrifter.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.GRAVITY, 0.005).add(Attributes.JUMP_STRENGTH, 0.1);
    }

    public static boolean canSpawn(EntityType<?> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    protected Brain.Provider<AbstractDrifter> brainProvider() {
        return Brain.provider((Collection)((Collection)DrifterAI.MEMORY_TYPES.get()), (Collection)((Collection)DrifterAI.SENSOR_TYPES.get()));
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return DrifterAI.makeBrain((Brain<AbstractDrifter>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<AbstractDrifter> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ProfilerFiller profiler = server.getProfiler();
            profiler.push("drifterBrain");
            this.getBrain().tick(server, (LivingEntity)this);
            profiler.pop();
            profiler.push("drifterActivityUpdate");
            DrifterAI.updateActivity(this);
            profiler.pop();
        }
        super.customServerAiStep();
    }

    public abstract SoundEvent getJumpSound();

    public void aiStep() {
        super.aiStep();
        if (this.onGround()) {
            this.jumpFromGround();
        }
        if (this.isInLiquid()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.025, 0.0));
        }
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        if (this.isAlive()) {
            this.playSound(this.getJumpSound(), 1.0f, 1.0f);
        }
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        super.usePlayerItem(player, hand, stack);
        if (this.isFood(stack)) {
            this.playEatingSound();
        }
    }

    protected void playEatingSound() {
        SoundEvent sound = this.isBaby() ? EnderscapeEntitySounds.DRIFTLET_EAT.get() : EnderscapeEntitySounds.DRIFTER_EAT.get();
        this.level().playSound(null, (Entity)this, sound, this.getSoundSource(), this.getSoundVolume(), this.getVoicePitch());
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(false);
        return navigation;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public float getVoicePitch() {
        return Mth.nextFloat((RandomSource)this.random, (float)0.8f, (float)1.2f);
    }

    public boolean causeFallDamage(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public boolean onClimbable() {
        return false;
    }

    public boolean isBaby() {
        return this instanceof Driftlet;
    }

    protected void jumpInLiquid(TagKey<Fluid> tagKey) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.1, 0.0));
    }

    public boolean canBeLeashed() {
        return !this.isLeashed();
    }

    public Vec3 getLeashOffset() {
        return this.isBaby() ? new Vec3(0.0, (double)(this.getEyeHeight() + 0.26f), (double)(this.getBbWidth() * 0.05f)) : new Vec3(0.0, (double)(this.getEyeHeight() + 0.38f), 0.0);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(EnderscapeItemTags.DRIFTER_FOOD);
    }
}

