/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.drifter;

import java.util.Optional;
import net.bunten.enderscape.entity.ai.behavior.DrifterStartOrStopLeakingJelly;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDamageTypes;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Drifter
extends AbstractDrifter {
    private static final String DRIPPING_JELLY_KEY = "DrippingJelly";
    private static final EntityDataAccessor<Boolean> DRIPPING_JELLY = SynchedEntityData.defineId(Drifter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Drifter(EntityType<? extends Drifter> type, Level world) {
        super(type, world);
        DrifterStartOrStopLeakingJelly.refreshCooldown(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Drifter.createBaseDrifterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FLYING_SPEED, 0.4);
    }

    public boolean isDrippingJelly() {
        return (Boolean)this.entityData.get(DRIPPING_JELLY);
    }

    public void setDrippingJelly(boolean value) {
        this.entityData.set(DRIPPING_JELLY, (Object)value);
    }

    protected Vec3 getEntityBounceVelocity(LivingEntity mob) {
        Vec3 vel = mob.getDeltaMovement();
        float boost = mob.isFallFlying() ? 1.5f : 1.0f;
        double height = 1.6;
        if (mob.isFallFlying()) {
            height += 0.4;
        }
        if (mob.isShiftKeyDown()) {
            height /= 2.0;
        }
        return new Vec3(vel.x * (double)boost, height, vel.z * (double)boost);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DRIPPING_JELLY, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(DRIPPING_JELLY_KEY, this.isDrippingJelly());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDrippingJelly(tag.getBoolean(DRIPPING_JELLY_KEY));
    }

    @Override
    public SoundEvent getJumpSound() {
        return EnderscapeEntitySounds.DRIFTER_JUMP.get();
    }

    private boolean hasFeatherFalling(LivingEntity mob) {
        try {
            HolderLookup.RegistryLookup registry = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Optional enchantment = registry.get(Enchantments.FEATHER_FALLING);
            return EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)enchantment.get()), (ItemStack)mob.getItemBySlot(EquipmentSlot.FEET)) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void aiStep() {
        Level level;
        super.aiStep();
        if (this.isAlive() && !this.level().isClientSide()) {
            this.level().getEntities((Entity)this, this.getBounceHitbox()).forEach(entity -> {
                LivingEntity mob;
                if (entity instanceof LivingEntity && (mob = (LivingEntity)entity).isAlive() && !mob.isSpectator() && !(mob instanceof AbstractDrifter)) {
                    this.collide(mob, this.getBounceHitbox());
                }
            });
        }
        if ((level = this.level()) instanceof ServerLevel) {
            Vec3 pos;
            ServerLevel server = (ServerLevel)level;
            if (this.isInLove() && !this.isDrippingJelly() && this.random.nextInt(8) == 0) {
                pos = this.position();
                server.sendParticles((ParticleOptions)EnderscapeParticles.DRIFT_JELLY_DRIPPING.get(), pos.x, pos.y + 0.5, pos.z, 1, (double)0.4f, 1.0, (double)0.4f, 0.1);
            }
            if (this.isDrippingJelly() && this.random.nextBoolean()) {
                pos = this.position();
                server.sendParticles((ParticleOptions)EnderscapeParticles.DRIFT_JELLY_DRIPPING.get(), pos.x, pos.y + 0.5, pos.z, 1, (double)0.4f, 1.0, (double)0.4f, 0.1);
            }
        }
    }

    @NotNull
    public AABB getBounceHitbox() {
        return this.getBoundingBox().inflate(0.25, 0.0, 0.25).deflate(0.0, 0.85, 0.0).move(0.0, 1.0, 0.0);
    }

    private void collide(LivingEntity mob, AABB bounceHitbox) {
        boolean isLeashOwner;
        boolean bl = isLeashOwner = this.isLeashed() && this.getLeashData().leashHolder == mob;
        if (!mob.onGround() && !isLeashOwner && mob.getDeltaMovement().y < (double)-0.1f && bounceHitbox.intersects(mob.getBoundingBox())) {
            Vec3 velocity = new Vec3(mob.getDeltaMovement().x, mob.isShiftKeyDown() ? -0.4 : 0.6, mob.getDeltaMovement().z);
            this.setDeltaMovement(velocity);
            mob.setDeltaMovement(this.getEntityBounceVelocity(mob));
            this.gameEvent((Holder)GameEvent.STEP, (Entity)mob);
            if (mob instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)mob;
                EnderscapeCriteria.BOUNCE_ON_DRIFTER.trigger(player, this);
                player.awardStat(EnderscapeStats.DRIFTER_BOUNCE);
                player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)mob));
            }
            mob.fallDistance = 0.0f;
            this.playSound(EnderscapeEntitySounds.DRIFTER_BOUNCE.get(), 1.0f, 1.0f);
            this.hurt(this.level().damageSources().source(EnderscapeDamageTypes.STOMP, (Entity)mob), this.hasFeatherFalling(mob) ? 0.0f : 1.0f);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Items.GLASS_BOTTLE) && this.isDrippingJelly()) {
            if (!this.level().isClientSide()) {
                stack.consume(1, (LivingEntity)player);
                ItemStack jelly = new ItemStack((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get());
                if (!player.getInventory().add(jelly)) {
                    player.drop(jelly, false);
                }
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)player);
                this.playSound(EnderscapeEntitySounds.DRIFTER_MILK.get(), 0.5f, 1.0f);
                this.setDrippingJelly(false);
                DrifterStartOrStopLeakingJelly.refreshCooldown(this);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal other) {
        super.spawnChildFromBreeding(world, other);
        if (!world.isClientSide()) {
            ((Drifter)other).setDrippingJelly(true);
            this.setDrippingJelly(true);
        }
    }

    protected SoundEvent getAmbientSound() {
        return EnderscapeEntitySounds.DRIFTER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        LivingEntity mob;
        Entity entity;
        if (source.is(EnderscapeDamageTypes.STOMP) && (entity = source.getEntity()) instanceof LivingEntity && this.hasFeatherFalling(mob = (LivingEntity)entity)) {
            return EnderscapeEntitySounds.DRIFTER_HURT_SILENT.get();
        }
        return EnderscapeEntitySounds.DRIFTER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return EnderscapeEntitySounds.DRIFTER_DEATH.get();
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)EnderscapeEntities.DRIFTLET.get()).create((Level)world);
    }

    public void setBaby(boolean baby) {
    }
}

