/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.drifter;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.ai.EnderscapeSensors;
import net.bunten.enderscape.entity.ai.behavior.CalmDownFromAttacker;
import net.bunten.enderscape.entity.ai.behavior.CalmDownFromIntimidator;
import net.bunten.enderscape.entity.ai.behavior.DrifterRefreshHomePosition;
import net.bunten.enderscape.entity.ai.behavior.DrifterStartOrStopLeakingJelly;
import net.bunten.enderscape.entity.ai.behavior.DrifterWanderAround;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.bunten.enderscape.registry.tag.EnderscapePoiTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DrifterAI {
    public static final Supplier<ImmutableList<MemoryModuleType<? extends Object>>> MEMORY_TYPES = Suppliers.memoize(() -> ImmutableList.of((Object)EnderscapeMemory.AVOID_TARGET, (Object)EnderscapeMemory.BREED_TARGET, (Object)EnderscapeMemory.CANT_REACH_WALK_TARGET_SINCE, EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN.get(), EnderscapeMemory.DRIFTER_JELLY_CHANGE_COOLDOWN.get(), (Object)EnderscapeMemory.HOME, (Object)EnderscapeMemory.HURT_BY_ENTITY, (Object)EnderscapeMemory.IS_PANICKING, (Object)EnderscapeMemory.IS_TEMPTED, (Object)EnderscapeMemory.LOOK_TARGET, (Object)EnderscapeMemory.NEAREST_ATTACKABLE, EnderscapeMemory.NEAREST_INTIMIDATOR.get(), (Object[])new MemoryModuleType[]{EnderscapeMemory.NEAREST_LIVING_ENTITIES, EnderscapeMemory.NEAREST_VISIBLE_ADULT, EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES, EnderscapeMemory.NEAREST_VISIBLE_PLAYER, EnderscapeMemory.PATH, EnderscapeMemory.TEMPTATION_COOLDOWN_TICKS, EnderscapeMemory.TEMPTING_PLAYER, EnderscapeMemory.WALK_TARGET}));
    public static final Supplier<ImmutableList<SensorType<? extends Sensor<? super AbstractDrifter>>>> SENSOR_TYPES = Suppliers.memoize(() -> ImmutableList.of(EnderscapeSensors.DRIFTER_TEMPTATIONS.get(), (Object)EnderscapeSensors.HURT_BY, (Object)EnderscapeSensors.IS_IN_WATER, EnderscapeSensors.NEAREST_ADULT_DRIFTER.get(), EnderscapeSensors.NEAREST_INTIMIDATOR.get(), (Object)EnderscapeSensors.NEAREST_LIVING_ENTITIES, (Object)EnderscapeSensors.NEAREST_PLAYERS));

    public static GlobalPos getHome(AbstractDrifter mob) {
        return (GlobalPos)mob.getBrain().getMemory(EnderscapeMemory.HOME).get();
    }

    public static void setHome(AbstractDrifter mob, GlobalPos value) {
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.getPoiManager().getType(value.pos()).ifPresent(type -> {
                level2.getPoiManager().take(poi -> poi.is(EnderscapePoiTags.DRIFTER_HOME), (type2, pos) -> pos.equals((Object)value.pos()), value.pos(), 1);
                DebugPackets.sendPoiTicketCountPacket((ServerLevel)level2, (BlockPos)value.pos());
            });
        }
        mob.getBrain().setMemory(EnderscapeMemory.HOME, (Object)value);
    }

    public static Brain<?> makeBrain(Brain<AbstractDrifter> brain) {
        DrifterAI.initCoreActivity(brain);
        DrifterAI.initIdleActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<AbstractDrifter> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new CalmDownFromAttacker(24)), (Object)((Object)new CalmDownFromIntimidator(24)), (Object)new CountDownCooldownTicks(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN.get()), (Object)new CountDownCooldownTicks(EnderscapeMemory.DRIFTER_JELLY_CHANGE_COOLDOWN.get()), (Object)new CountDownCooldownTicks(EnderscapeMemory.TEMPTATION_COOLDOWN_TICKS), (Object)((Object)new DrifterStartOrStopLeakingJelly()), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)((Object)new DrifterRefreshHomePosition()), (Object)new Swim(0.8f), (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)EnderscapeMemory.HURT_BY_ENTITY, (float)2.0f, (int)12, (boolean)true), (Object)SetWalkTargetAwayFrom.entity(EnderscapeMemory.NEAREST_INTIMIDATOR.get(), (float)2.0f, (int)8, (boolean)true), (Object[])new BehaviorControl[0]));
    }

    private static void initIdleActivity(Brain<AbstractDrifter> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)EnderscapeEntities.DRIFTER.get())), (Object)Pair.of((Object)1, (Object)new FollowTemptation(mob -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)4, (int)16), (float)2.0f)), (Object)Pair.of((Object)3, (Object)SetWalkTargetAwayFrom.entity(EnderscapeMemory.NEAREST_INTIMIDATOR.get(), (float)1.0f, (int)12, (boolean)true)), (Object)Pair.of((Object)4, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)5, (Object)SetEntityLookTargetSometimes.create((EntityType)((EntityType)EnderscapeEntities.DRIFTLET.get()), (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)8, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of(DrifterWanderAround.create(), (Object)3), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)3))))));
    }

    public static void updateActivity(AbstractDrifter entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(EnderscapeItemTags.DRIFTER_FOOD);
    }
}

