/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.drifter;

import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.entity.drifter.Drifter;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Driftlet
extends AbstractDrifter {
    public static int MAX_GROWTH_AGE = 24000;
    private int growthAge;

    public Driftlet(EntityType<? extends AbstractDrifter> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Driftlet.createBaseDrifterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FLYING_SPEED, 0.5);
    }

    private void ageUp() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Drifter drifter = (Drifter)this.convertTo((EntityType)EnderscapeEntities.DRIFTER.get(), true);
            drifter.finalizeSpawn((ServerLevelAccessor)server, this.level().getCurrentDifficultyAt(drifter.blockPosition()), MobSpawnType.CONVERSION, null);
            drifter.setPersistenceRequired();
            drifter.fudgePositionAfterSizeChange(this.getDimensions(this.getPose()));
            this.convertTo(EntityType.STRAY, true);
        }
    }

    private void setGrowthAge(int value) {
        this.growthAge = value;
        if (this.growthAge >= MAX_GROWTH_AGE && this.level().noCollision(this.getBoundingBox().inflate(1.0))) {
            this.ageUp();
        }
    }

    private void increaseAge(int seconds) {
        this.setGrowthAge(this.growthAge + seconds * 20);
    }

    private int getTicksUntilGrowth() {
        return Math.max(0, MAX_GROWTH_AGE - this.growthAge);
    }

    @Override
    public SoundEvent getJumpSound() {
        return EnderscapeEntitySounds.DRIFTLET_JUMP.get();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            this.setGrowthAge(this.growthAge + 1);
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("Age", this.growthAge);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setGrowthAge(nbt.getInt("Age"));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(EnderscapeItemTags.DRIFTER_FOOD)) {
            this.usePlayerItem(player, hand, stack);
            this.increaseAge(AgeableMob.getSpeedUpSecondsWhenFeeding((int)this.getTicksUntilGrowth()));
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getAmbientSound() {
        return EnderscapeEntitySounds.DRIFTLET_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return EnderscapeEntitySounds.DRIFTLET_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return EnderscapeEntitySounds.DRIFTLET_DEATH.get();
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }
}

