/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.magnia;

import java.util.function.Predicate;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.registry.tag.EnderscapeEntityTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface MagniaMoveable {
    public static final Predicate<Entity> DEFAULT_MAGNIA_PREDICATE = entity -> (entity.getType().is(EnderscapeEntityTags.AFFECTED_BY_MAGNIA) || MagniaMoveable.getMagnetismFactor(entity) > 0.0f) && EntitySelector.NO_SPECTATORS.test(entity);
    public static final AttributeModifier MAGNIA_GRAVITY_MODIFIER = new AttributeModifier(Enderscape.id("magnia_gravity"), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public MagniaProperties createMagniaProperties();

    @Nullable
    public static MagniaProperties getMagniaProperties(Entity entity) {
        if (entity instanceof MagniaMoveable) {
            MagniaMoveable moveable = (MagniaMoveable)entity;
            return moveable.createMagniaProperties();
        }
        return null;
    }

    public static boolean canMagniaAffect(Entity entity) {
        if (!(entity instanceof MagniaMoveable)) {
            return false;
        }
        MagniaProperties properties = MagniaMoveable.getMagniaProperties(entity);
        if (properties != null) {
            Predicate<Entity> predicate = properties.isAllowed();
            return predicate.test(entity);
        }
        return false;
    }

    public static boolean is(Entity entity) {
        return entity instanceof MagniaMoveable;
    }

    public static float getMagnetismFactor(Entity entity) {
        float factor = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity;
            int weak = 0;
            int average = 0;
            int strong = 0;
            for (ItemStack stack : mob.getArmorSlots()) {
                if (stack.is(EnderscapeItemTags.WEAK_MAGNETISM_WHEN_WORN)) {
                    ++weak;
                    continue;
                }
                if (stack.is(EnderscapeItemTags.AVERAGE_MAGNETISM_WHEN_WORN)) {
                    ++average;
                    continue;
                }
                if (!stack.is(EnderscapeItemTags.STRONG_MAGNETISM_WHEN_WORN)) continue;
                ++strong;
            }
            factor += (float)weak * 0.5f + (float)average + (float)strong * 1.5f;
        }
        return factor;
    }
}

