/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rubblemite;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rubblemite.RubblemiteAI;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariant;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeDamageTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Rubblemite
extends Monster {
    private static final String RUBBLEMITE_FLAGS_KEY = "RubblemiteFlags";
    public static final int DEFAULT_FLAG = 0;
    public static final int INSIDE_SHELL_FLAG = 1;
    public static final int DASHING_FLAG = 2;
    private static final EntityDataAccessor<Integer> RUBBLEMITE_FLAGS = SynchedEntityData.defineId(Rubblemite.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> VARIANT_DATA = SynchedEntityData.defineId(Rubblemite.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Rubblemite(EntityType<? extends Rubblemite> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Rubblemite.createMobAttributes().add(Attributes.ARMOR, 15.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.SAFE_FALL_DISTANCE, 6.0);
    }

    protected Brain.Provider<Rubblemite> brainProvider() {
        return Brain.provider((Collection)((Collection)RubblemiteAI.MEMORY_TYPES.get()), (Collection)((Collection)RubblemiteAI.SENSOR_TYPES.get()));
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return RubblemiteAI.makeBrain((Brain<Rubblemite>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Rubblemite> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ProfilerFiller profiler = server.getProfiler();
            profiler.push("rubblemiteBrain");
            this.getBrain().tick(server, (LivingEntity)this);
            profiler.pop();
            profiler.push("rubblemiteActivityUpdate");
            RubblemiteAI.updateActivity(this);
            profiler.pop();
        }
        super.customServerAiStep();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        RubblemiteVariant.set(this, RubblemiteVariant.pickForSpawning(this.random, (Holder<Biome>)level.getBiome(this.blockPosition())));
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public static boolean canSpawn(EntityType<?> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && (level.getBlockState(pos.below()).is(EnderscapeBlockTags.RUBBLEMITE_SPAWNABLE_ON) || MobSpawnType.isSpawner((MobSpawnType)spawnType));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RUBBLEMITE_FLAGS, (Object)0);
        builder.define(VARIANT_DATA, (Object)RubblemiteVariant.END_STONE.getId());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt(RUBBLEMITE_FLAGS_KEY, this.getFlags());
        tag.putInt("RubblemiteVariant", RubblemiteVariant.get(this).getId());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFlags(tag.getInt(RUBBLEMITE_FLAGS_KEY));
        RubblemiteVariant.set(this, RubblemiteVariant.byId(tag.getInt("RubblemiteVariant")));
    }

    public int getFlags() {
        return (Integer)this.entityData.get(RUBBLEMITE_FLAGS);
    }

    public void setFlags(int value) {
        this.entityData.set(RUBBLEMITE_FLAGS, (Object)value);
    }

    public boolean isInsideShell() {
        return this.getFlags() == 1 || this.brain.hasMemoryValue(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION.get());
    }

    public boolean isDashing() {
        return this.getFlags() == 2 && !this.brain.hasMemoryValue(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN.get());
    }

    public void enterShell(int value) {
        this.setFlags(1);
        if (value > 0) {
            this.brain.setMemory(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION.get(), (Object)value);
        }
    }

    public void exitShell() {
        this.setFlags(0);
        this.brain.eraseMemory(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION.get());
        this.brain.setMemoryWithExpiry(EnderscapeMemory.RUBBLEMITE_HIDING_ON_COOLDOWN.get(), (Object)true, 100L);
        this.brain.setMemoryWithExpiry(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN.get(), (Object)true, 20L);
    }

    public boolean canHideInShell() {
        return this.getFlags() == 0 && !RubblemiteAI.isShellCoolingDown(this);
    }

    public boolean shouldStopDashing() {
        return this.onGround() || this.isInWaterOrRain() || this.getVehicle() != null;
    }

    public void dash() {
        Vec3 vec = this.getLookAngle();
        vec = vec.multiply(1.4, 0.0, 1.4).add(0.0, (double)0.33f, 0.0);
        this.setDeltaMovement(vec);
        this.playSound(EnderscapeEntitySounds.RUBBLEMITE_HOP.get(), 1.0f, 1.0f);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Vec3 pos = this.position();
            server.sendParticles((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y + 0.5, pos.z, 5, 0.0, 0.0, 0.0, 0.1);
        }
        this.setFlags(2);
    }

    protected void onDamageBlocked(DamageSource source) {
        if (source.getDirectEntity() != null) {
            float knockback = 1.0f;
            Entity entity = source.getDirectEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                HolderLookup.RegistryLookup enchantments = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                knockback += (float)EnchantmentHelper.getEnchantmentLevel((Holder)enchantments.getOrThrow(Enchantments.KNOCKBACK), (LivingEntity)living);
            }
            double x = source.getDirectEntity().getX() - this.getX();
            double z = source.getDirectEntity().getZ() - this.getZ();
            while (x * x + z * z < 1.0E-4) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            this.knockback(knockback * 0.5f, x, z);
        }
        this.playSound(EnderscapeEntitySounds.RUBBLEMITE_SHIELD.get(), 1.0f, 1.0f);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isAlive() && source.is(EnderscapeDamageTypeTags.RUBBLEMITES_CAN_BLOCK)) {
            if (amount >= 12.0f && super.hurt(source, amount)) {
                return true;
            }
            if (this.isDashing() || this.isInsideShell()) {
                this.onDamageBlocked(source);
                return false;
            }
            if (this.canHideInShell() && super.hurt(source, amount)) {
                this.enterShell(40);
                return true;
            }
        }
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        this.enterShell(0);
    }

    public void travel(Vec3 vec) {
        if (this.isInsideShell()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec = Vec3.ZERO;
        }
        super.travel(vec);
    }

    public void lookAt(Entity entity, float f, float g) {
        if (this.isInsideShell() || this.isDashing()) {
            return;
        }
        super.lookAt(entity, f, g);
    }

    public boolean doHurtTarget(Entity entity) {
        return !this.isInsideShell() && super.doHurtTarget(entity);
    }

    protected SoundEvent getAmbientSound() {
        return this.isInsideShell() ? null : EnderscapeEntitySounds.RUBBLEMITE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return EnderscapeEntitySounds.RUBBLEMITE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return EnderscapeEntitySounds.RUBBLEMITE_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return EnderscapeEntitySounds.RUBBLEMITE_STEP.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(this.getStepSound(), 0.15f, Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.1f));
    }
}

