/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rubblemite;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bunten.enderscape.entity.ai.EnderscapeAI;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.ai.EnderscapeSensors;
import net.bunten.enderscape.entity.ai.behavior.RubblemiteDashDuringCombat;
import net.bunten.enderscape.entity.ai.behavior.RubblemiteManageFlags;
import net.bunten.enderscape.entity.ai.behavior.RubblemiteShellCooldown;
import net.bunten.enderscape.entity.rubblemite.Rubblemite;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class RubblemiteAI {
    public static final Supplier<ImmutableList<MemoryModuleType<? extends Object>>> MEMORY_TYPES = Suppliers.memoize(() -> ImmutableList.of((Object)EnderscapeMemory.ANGRY_AT, (Object)EnderscapeMemory.ATTACK_COOLING_DOWN, (Object)EnderscapeMemory.ATTACK_TARGET, (Object)EnderscapeMemory.AVOID_TARGET, (Object)EnderscapeMemory.CANT_REACH_WALK_TARGET_SINCE, (Object)EnderscapeMemory.HURT_BY_ENTITY, (Object)EnderscapeMemory.LOOK_TARGET, (Object)EnderscapeMemory.NEAREST_ATTACKABLE, EnderscapeMemory.NEAREST_ENEMIES.get(), (Object)EnderscapeMemory.NEAREST_LIVING_ENTITIES, EnderscapeMemory.NEAREST_VISIBLE_ATTACKABLE_ENEMY.get(), EnderscapeMemory.NEAREST_VISIBLE_ENEMY.get(), (Object[])new MemoryModuleType[]{EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES, EnderscapeMemory.NEAREST_VISIBLE_PLAYER, EnderscapeMemory.PATH, EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN.get(), EnderscapeMemory.RUBBLEMITE_HIDING_DURATION.get(), EnderscapeMemory.RUBBLEMITE_HIDING_ON_COOLDOWN.get(), EnderscapeMemory.WALK_TARGET}));
    public static final Supplier<ImmutableList<SensorType<? extends Sensor<? super Rubblemite>>>> SENSOR_TYPES = Suppliers.memoize(() -> ImmutableList.of((Object)EnderscapeSensors.HURT_BY, (Object)EnderscapeSensors.NEAREST_ITEMS, (Object)EnderscapeSensors.NEAREST_LIVING_ENTITIES, (Object)EnderscapeSensors.NEAREST_PLAYERS, EnderscapeSensors.RUBBLEMITE_NEAREST_ENEMIES.get()));

    public static boolean isShellCoolingDown(Rubblemite mob) {
        Brain<Rubblemite> brain = mob.getBrain();
        if (brain.hasMemoryValue(EnderscapeMemory.RUBBLEMITE_HIDING_ON_COOLDOWN.get())) {
            Optional cooling = brain.getMemory(EnderscapeMemory.RUBBLEMITE_HIDING_ON_COOLDOWN.get());
            return cooling.orElse(false);
        }
        return false;
    }

    public static Brain<?> makeBrain(Brain<Rubblemite> brain) {
        RubblemiteAI.initCoreActivity(brain);
        RubblemiteAI.initIdleActivity(brain);
        RubblemiteAI.initFightActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(Rubblemite mob) {
        mob.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    private static void initCoreActivity(Brain<Rubblemite> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new MoveToTargetSink(), (Object)new LookAtTargetSink(45, 90), (Object)((Object)new RubblemiteShellCooldown()), (Object)((Object)new RubblemiteManageFlags()), (Object)StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<Rubblemite> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)1, (Object)StartAttacking.create(EnderscapeAI::getAttackTarget)), (Object)Pair.of((Object)4, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)8, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)3), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)3))))));
    }

    private static void initFightActivity(Brain<Rubblemite> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)((Object)new RubblemiteDashDuringCombat()), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)BehaviorBuilder.triggerIf(Predicate.not(Rubblemite::isDashing), (OneShot)MeleeAttack.create((int)15)), (Object)StopAttackingIfTargetInvalid.create()), EnderscapeMemory.ATTACK_TARGET);
    }
}

