/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rubblemite;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import net.bunten.enderscape.entity.rubblemite.Rubblemite;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBiomeTags;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public enum RubblemiteVariant implements StringRepresentable
{
    END_STONE(0, "end_stone", () -> Blocks.END_STONE, 8, EnderscapeBiomeTags.DOES_NOT_SPAWN_END_STONE_RUBBLEMITES),
    MIRESTONE(1, "mirestone", EnderscapeBlocks.MIRESTONE, 4, EnderscapeBiomeTags.DOES_NOT_SPAWN_MIRESTONE_RUBBLEMITES),
    VERADITE(2, "veradite", EnderscapeBlocks.VERADITE, 1, EnderscapeBiomeTags.DOES_NOT_SPAWN_VERADITE_RUBBLEMITES),
    KURODITE(3, "kurodite", EnderscapeBlocks.KURODITE, 1, EnderscapeBiomeTags.DOES_NOT_SPAWN_KURODITE_RUBBLEMITES);

    public static final String KEY = "RubblemiteVariant";
    public static final Codec<RubblemiteVariant> CODEC;
    public static final RubblemiteVariant[] BY_ID;
    private final int id;
    private final String name;
    private final Supplier<? extends ItemLike> dropItem;
    private final int weight;
    private final TagKey<Biome> skippedBiomes;

    private RubblemiteVariant(int id, String name, Supplier<? extends ItemLike> dropItem, int weight, TagKey<Biome> skippedBiomes) {
        this.id = id;
        this.name = name;
        this.dropItem = dropItem;
        this.weight = weight;
        this.skippedBiomes = skippedBiomes;
    }

    public int getId() {
        return this.id;
    }

    public static RubblemiteVariant byId(int id) {
        return id >= 0 && id < BY_ID.length ? BY_ID[id] : END_STONE;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.getName();
    }

    public ItemLike getDropItem() {
        return this.dropItem.get();
    }

    public int getWeight() {
        return this.weight;
    }

    public TagKey<Biome> getSkippedBiomes() {
        return this.skippedBiomes;
    }

    public static RubblemiteVariant get(Rubblemite mob) {
        return BY_ID[(Integer)mob.getEntityData().get(Rubblemite.VARIANT_DATA)];
    }

    public static void set(Rubblemite mob, RubblemiteVariant variant) {
        mob.getEntityData().set(Rubblemite.VARIANT_DATA, (Object)variant.getId());
    }

    public static RubblemiteVariant pickForSpawning(RandomSource random, Holder<Biome> biome) {
        int totalWeight = Arrays.stream(RubblemiteVariant.values()).filter(variant -> !biome.is(variant.getSkippedBiomes())).mapToInt(RubblemiteVariant::getWeight).sum();
        int roll = random.nextInt(totalWeight);
        int cumulativeWeight = 0;
        for (RubblemiteVariant variant2 : RubblemiteVariant.values()) {
            if (biome.is(variant2.getSkippedBiomes()) || roll >= (cumulativeWeight += variant2.getWeight())) continue;
            return variant2;
        }
        throw new IllegalStateException("No variant could be selected");
    }

    static {
        CODEC = StringRepresentable.fromEnum(RubblemiteVariant::values);
        BY_ID = (RubblemiteVariant[])Arrays.stream(RubblemiteVariant.values()).sorted(Comparator.comparingInt(RubblemiteVariant::getId)).toArray(RubblemiteVariant[]::new);
    }
}

