/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rustle;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rustle.RustleAI;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntityLootTables;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.bunten.enderscape.registry.tag.EnderscapePoiTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Rustle
extends Animal
implements Bucketable,
Shearable {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Rustle.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(Rustle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(Rustle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(Rustle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState sleepingAnimationState = new AnimationState();
    private long lastBumpTimestamp = 0L;
    private static final long BUMP_COOLDOWN_TIME = 20L;

    public Rustle(EntityType<? extends Rustle> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Rustle.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.13).add(Attributes.SAFE_FALL_DISTANCE, 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(SLEEPING, (Object)false);
        builder.define(SHEARED, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("FromBucket", this.fromBucket());
        tag.putBoolean("Sleeping", this.isSleeping());
        tag.putBoolean("Sheared", this.isSheared());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFromBucket(tag.getBoolean("FromBucket"));
        this.setSleeping(tag.getBoolean("Sleeping"));
        this.setSheared(tag.getBoolean("Sheared"));
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            tag.putInt("Age", this.getAge());
            if (this.isSheared()) {
                tag.putBoolean("Sheared", this.isSheared());
            }
            if (this.getBrain().hasMemoryValue(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN.get())) {
                tag.putInt("HairRegrowthCooldownTicks", ((Integer)this.getBrain().getMemory(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN.get()).orElseThrow()).intValue());
            }
        });
    }

    public void loadFromBucketTag(CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("Sheared")) {
            this.setSheared(tag.getBoolean("Sheared"));
        }
        if (tag.contains("HairRegrowthCooldownTicks")) {
            this.getBrain().setMemory(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN.get(), (Object)tag.getInt("HairRegrowthCooldownTicks"));
        }
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    protected Brain.Provider<Rustle> brainProvider() {
        return Brain.provider((Collection)((Collection)RustleAI.MEMORY_TYPES.get()), (Collection)((Collection)RustleAI.SENSOR_TYPES.get()));
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return RustleAI.makeBrain((Brain<Rustle>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Rustle> getBrain() {
        return super.getBrain();
    }

    public void tick() {
        super.tick();
        if (this.isSleeping()) {
            this.sleepingAnimationState.startIfStopped(this.tickCount);
        } else {
            this.sleepingAnimationState.stop();
        }
        if (this.isAlive() && this.isSleeping() && this.level().getGameTime() % (long)(60 + this.getRandom().nextInt(20)) == 0L && this.level().isClientSide()) {
            Vec3 pos = this.position().add(this.getLookAngle().scale(0.5));
            this.level().addParticle((ParticleOptions)EnderscapeParticles.RUSTLE_SLEEPING_BUBBLE.get(), pos.x, this.getY() + (double)this.getBbHeight() - (double)0.1f, pos.z, 0.0, 0.0, 0.0);
        }
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ProfilerFiller profiler = server.getProfiler();
            profiler.push("rustleBrain");
            this.getBrain().tick(server, (LivingEntity)this);
            profiler.pop();
            profiler.push("rustleActivityUpdate");
            RustleAI.updateActivity(this);
            profiler.pop();
            if (this.isSleeping()) {
                this.getBrain().getMemory(EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get()).ifPresentOrElse(pos -> {
                    if (!server.getPoiManager().exists(pos, type -> type.is(EnderscapePoiTags.RUSTLE_SLEEPING_SPOT))) {
                        this.getBrain().eraseMemory(EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get());
                        this.wakeUp();
                    }
                    if (this.isInWaterRainOrBubble() || this.getDeltaMovement().lengthSqr() > 0.1 || !server.getPoiManager().exists(this.blockPosition(), type -> type.is(EnderscapePoiTags.RUSTLE_SLEEPING_SPOT))) {
                        this.wakeUp();
                    }
                }, this::wakeUp);
            }
            this.setSleeping(this.getBrain().hasMemoryValue(EnderscapeMemory.RUSTLE_SLEEP_TICKS.get()));
        }
        super.customServerAiStep();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(EnderscapeBlockTags.RUSTLE_PREFERRED) ? 10.0f : 0.0f;
    }

    public static boolean canSpawn(EntityType<?> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(EnderscapeBlockTags.RUSTLE_SPAWNABLE_ON);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (reason == MobSpawnType.BUCKET) {
            return data;
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    public boolean canBeAffected(MobEffectInstance instance) {
        return !instance.is(MobEffects.POISON) && super.canBeAffected(instance);
    }

    protected void doPush(Entity entity) {
        long gameTime;
        super.doPush(entity);
        if (this.getVehicle() == null && entity.getType() != this.getType() && !entity.isCrouching() && (gameTime = this.level().getGameTime()) - this.lastBumpTimestamp > 20L) {
            this.lastBumpTimestamp = gameTime;
            this.playSound(EnderscapeEntitySounds.RUSTLE_BUMP.get(), 1.0f, this.getVoicePitch());
            this.getNavigation().stop();
            if (this.isSleeping()) {
                this.wakeUp();
            }
        }
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean value) {
        this.entityData.set(FROM_BUCKET, (Object)value);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setSleeping(boolean value) {
        this.entityData.set(SLEEPING, (Object)value);
    }

    public void wakeUp() {
        this.getBrain().eraseMemory(EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get());
        this.getBrain().eraseMemory(EnderscapeMemory.RUSTLE_SLEEP_TICKS.get());
        this.getBrain().setMemoryWithExpiry(EnderscapeMemory.RUSTLE_SLEEPING_ON_COOLDOWN.get(), (Object)true, 100L);
        this.setSleeping(false);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean value) {
        this.entityData.set(SHEARED, (Object)value);
    }

    public void shear(SoundSource source) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            LootTable lootTable = server.getServer().reloadableRegistries().getLootTable(EnderscapeEntityLootTables.SHEARING_RUSTLE);
            LootParams lootParams = new LootParams.Builder(server).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.SHEARING);
            for (ItemStack item : lootTable.getRandomItems(lootParams)) {
                ItemEntity entity = this.spawnAtLocation(item, 0.2f);
                if (entity == null) continue;
                entity.setDeltaMovement(entity.getDeltaMovement().add((double)Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)0.05f), (double)Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f)));
            }
        }
        this.playSound(EnderscapeEntitySounds.RUSTLE_SHEAR.get(), 1.0f, 1.0f);
        this.setSheared(true);
        RustleAI.refreshNaturalHairGrowthCooldown(this);
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby() && !this.isSheared();
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result && this.isSleeping()) {
            this.wakeUp();
        }
        return result;
    }

    public static void regrowHairWithParticles(ServerLevel level, Rustle mob) {
        Vec3 pos = mob.position();
        level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, pos.x, pos.y + 0.5, pos.z, 5, 0.5, 0.5, 0.5, 0.0);
        mob.setSheared(false);
        RustleAI.refreshNaturalHairGrowthCooldown(mob);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isFood(stack) && this.isSleeping()) {
            return InteractionResult.PASS;
        }
        if (this.isAlive()) {
            if (stack.getItem() == Items.BUCKET) {
                this.playSound(this.getPickupSound(), 1.0f, 1.0f);
                ItemStack bucket = this.getBucketItemStack();
                this.saveToBucketTag(bucket);
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)bucket, (boolean)false));
                if (player instanceof ServerPlayer) {
                    ServerPlayer server = (ServerPlayer)player;
                    CriteriaTriggers.FILLED_BUCKET.trigger(server, bucket);
                }
                if (this.isLeashed()) {
                    this.dropLeash(true, true);
                }
                this.discard();
                return InteractionResult.SUCCESS;
            }
            if (stack.getItem() instanceof ShearsItem && this.readyForShearing()) {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    this.shear(SoundSource.PLAYERS);
                    stack.hurtAndBreak(1, (LivingEntity)player, Rustle.getSlotForHand((InteractionHand)hand));
                    this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(player, hand);
    }

    public SoundEvent getPickupSound() {
        return EnderscapeItemSounds.RUSTLE_BUCKET_FILL.get();
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)EnderscapeItems.RUSTLE_BUCKET.get());
    }

    public void travel(Vec3 vec) {
        if (this.isSleeping()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec = Vec3.ZERO;
        }
        super.travel(vec);
    }

    public void lookAt(Entity entity, float f, float g) {
        if (this.isSleeping()) {
            return;
        }
        super.lookAt(entity, f, g);
    }

    protected SoundEvent getAmbientSound() {
        return this.isSleeping() ? EnderscapeEntitySounds.RUSTLE_SNORE.get() : EnderscapeEntitySounds.RUSTLE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return EnderscapeEntitySounds.RUSTLE_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return EnderscapeEntitySounds.RUSTLE_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return EnderscapeEntitySounds.RUSTLE_STEP.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(this.getStepSound(), 0.15f, Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.1f));
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        super.usePlayerItem(player, hand, stack);
        if (this.isFood(stack)) {
            this.playEatingSound();
        }
    }

    protected void playEatingSound() {
        this.level().playSound(null, (Entity)this, EnderscapeEntitySounds.RUSTLE_EAT.get(), this.getSoundSource(), this.getSoundVolume(), this.getVoicePitch());
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(EnderscapeItemTags.RUSTLE_FOOD);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)EnderscapeEntities.RUSTLE.get()).create((Level)level);
    }
}

