/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rustle;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.ai.EnderscapeSensors;
import net.bunten.enderscape.entity.ai.behavior.CalmDownFromAttacker;
import net.bunten.enderscape.entity.ai.behavior.RustleEatWhenSheared;
import net.bunten.enderscape.entity.ai.behavior.RustleGoToSleep;
import net.bunten.enderscape.entity.ai.behavior.RustleRegrowHairNaturally;
import net.bunten.enderscape.entity.rustle.Rustle;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;

public class RustleAI {
    public static final Supplier<ImmutableList<MemoryModuleType<? extends Object>>> MEMORY_TYPES = Suppliers.memoize(() -> ImmutableList.of((Object)EnderscapeMemory.AVOID_TARGET, (Object)EnderscapeMemory.BREED_TARGET, (Object)EnderscapeMemory.CANT_REACH_WALK_TARGET_SINCE, (Object)EnderscapeMemory.HURT_BY_ENTITY, (Object)EnderscapeMemory.IS_PANICKING, (Object)EnderscapeMemory.IS_TEMPTED, (Object)EnderscapeMemory.LOOK_TARGET, (Object)EnderscapeMemory.NEAREST_ATTACKABLE, (Object)EnderscapeMemory.NEAREST_LIVING_ENTITIES, (Object)EnderscapeMemory.NEAREST_VISIBLE_ADULT, (Object)EnderscapeMemory.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)EnderscapeMemory.NEAREST_VISIBLE_PLAYER, (Object[])new MemoryModuleType[]{EnderscapeMemory.PATH, EnderscapeMemory.RUSTLE_SLEEPING_ON_COOLDOWN.get(), EnderscapeMemory.RUSTLE_FOOD.get(), EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN.get(), EnderscapeMemory.RUSTLE_SLEEPING_SPOT.get(), EnderscapeMemory.RUSTLE_SLEEP_TICKS.get(), EnderscapeMemory.TEMPTATION_COOLDOWN_TICKS, EnderscapeMemory.TEMPTING_PLAYER, EnderscapeMemory.WALK_TARGET}));
    public static final Supplier<ImmutableList<SensorType<? extends Sensor<? super Rustle>>>> SENSOR_TYPES = Suppliers.memoize(() -> ImmutableList.of((Object)EnderscapeSensors.HURT_BY, (Object)EnderscapeSensors.IS_IN_WATER, (Object)EnderscapeSensors.NEAREST_ADULT, (Object)EnderscapeSensors.NEAREST_LIVING_ENTITIES, (Object)EnderscapeSensors.NEAREST_PLAYERS, EnderscapeSensors.RUSTLE_NEAREST_FOOD.get(), EnderscapeSensors.RUSTLE_NEAREST_SLEEPING_SPOT.get(), EnderscapeSensors.RUSTLE_TEMPTATIONS.get()));
    public static final IntProvider HAIR_REGROWTH_COOLDOWN_RANGE_IN_MINUTES = UniformInt.of((int)4, (int)8);
    public static final IntProvider SLEEPING_TIME_RANGE_IN_MINUTES = ConstantInt.of((int)1);
    public static final BiPredicate<ServerLevel, BlockPos> HAS_STURDY_SURFACE = (level, pos) -> level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);

    public static Brain<?> makeBrain(Brain<Rustle> brain) {
        RustleAI.initCoreActivity(brain);
        RustleAI.initIdleActivity(brain);
        RustleAI.initRestActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(Rustle mob) {
        mob.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.REST, (Object)Activity.IDLE));
    }

    private static void initCoreActivity(Brain<Rustle> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new CalmDownFromAttacker(16)), (Object)new CountDownCooldownTicks(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN.get()), (Object)new CountDownCooldownTicks(EnderscapeMemory.RUSTLE_SLEEP_TICKS.get()), (Object)new CountDownCooldownTicks(EnderscapeMemory.TEMPTATION_COOLDOWN_TICKS), (Object)((Object)new RustleRegrowHairNaturally()), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new Swim(0.8f), (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)EnderscapeMemory.HURT_BY_ENTITY, (float)1.25f, (int)12, (boolean)true)));
    }

    private static void initIdleActivity(Brain<Rustle> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)EnderscapeEntities.RUSTLE.get(), 1.25f, 1)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(mob -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)((Object)new RustleEatWhenSheared(1.25f))), (Object)Pair.of((Object)3, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)2, (int)16), (float)1.25f)), (Object)Pair.of((Object)4, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)1.5f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)8, (Object)new RunOne((Map)ImmutableMap.of((Object)EnderscapeMemory.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)EnderscapeMemory.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)5), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)5), (Object)Pair.of((Object)((Object)new RustleGoToSleep(1.0f)), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(EnderscapeMemory.RUSTLE_SLEEP_TICKS.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initRestActivity(Brain<Rustle> brain) {
        brain.addActivityWithConditions(Activity.REST, ImmutableList.of((Object)Pair.of((Object)8, (Object)new DoNothing(30, 60))), Set.of(Pair.of(EnderscapeMemory.RUSTLE_SLEEPING_ON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)EnderscapeMemory.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT), Pair.of(EnderscapeMemory.RUSTLE_SLEEP_TICKS.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)EnderscapeMemory.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(EnderscapeItemTags.RUSTLE_FOOD);
    }

    public static void refreshNaturalHairGrowthCooldown(Rustle mob) {
        mob.getBrain().setMemory(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN.get(), (Object)(HAIR_REGROWTH_COOLDOWN_RANGE_IN_MINUTES.sample(mob.getRandom()) * 20 * 60));
    }
}

