/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.bunten.enderscape.feature.CeilingOreConfig;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class CeilingOreFeature
extends Feature<CeilingOreConfig> {
    public CeilingOreFeature(Codec<CeilingOreConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CeilingOreConfig> context) {
        CeilingOreConfig config = (CeilingOreConfig)context.config();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        boolean generated = false;
        Optional closest = BlockPos.findClosestMatch((BlockPos)context.origin(), (int)4, (int)32, pos -> level.getBlockState(pos).is(EnderscapeBlockTags.ORE_REPLACEABLE) && level.isEmptyBlock(pos.below()) && BlockUtil.hasTerrainDepth((LevelAccessor)level, pos, config.terrainDepth().sample(random), Direction.UP));
        if (closest.isPresent()) {
            for (OreConfiguration.TargetBlockState target : config.targets()) {
                if (!target.target.test(level.getBlockState((BlockPos)closest.get()), random)) continue;
                level.setBlock((BlockPos)closest.get(), target.state, 2);
                generated = true;
            }
        }
        return generated;
    }
}

