/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EnderscapeIslandFeature
extends Feature<NoneFeatureConfiguration> {
    public EnderscapeIslandFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel level = featurePlaceContext.level();
        RandomSource random = featurePlaceContext.random();
        BlockPos origin = featurePlaceContext.origin();
        float f = (float)random.nextInt(3) + 4.0f;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while (f > 0.5f) {
            for (int j = Mth.floor((float)(-f)); j <= Mth.ceil((float)f); ++j) {
                for (int k = Mth.floor((float)(-f)); k <= Mth.ceil((float)f); ++k) {
                    if (!((float)(j * j + k * k) <= (f + 1.0f) * (f + 1.0f))) continue;
                    list.add(origin.offset(j, i, k));
                }
            }
            f -= (float)random.nextInt(2) + 0.5f;
            --i;
        }
        int lowest = Integer.MAX_VALUE;
        int highest = Integer.MIN_VALUE;
        for (BlockPos pos : list) {
            this.setBlock((LevelWriter)level, pos, Blocks.END_STONE.defaultBlockState());
            if (pos.getY() < lowest) {
                lowest = pos.getY();
            }
            if (pos.getY() <= highest) continue;
            highest = pos.getY();
        }
        return true;
    }
}

