/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import java.util.HashSet;
import java.util.Set;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MagniaArchFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int RADIUS = 2;

    public MagniaArchFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        HashSet<BlockPos> mains = new HashSet<BlockPos>();
        HashSet<BlockPos> decorations = new HashSet<BlockPos>();
        int maxDistance = UniformInt.of((int)3, (int)7).sample(random);
        if (maxDistance <= 4 && random.nextInt(3) == 0) {
            maxDistance *= 2;
        }
        BlockPos leftSide = new BlockPos(origin.getX() - maxDistance, origin.getY(), origin.getZ());
        BlockPos rightSide = new BlockPos(origin.getX() + maxDistance, origin.getY(), origin.getZ());
        if (!BlockUtil.hasTerrainDepth((LevelAccessor)level, leftSide, 12, Direction.DOWN)) {
            return false;
        }
        if (!BlockUtil.hasTerrainDepth((LevelAccessor)level, rightSide, 12, Direction.DOWN)) {
            return false;
        }
        this.calculateArch(random, origin, level, mains, maxDistance);
        this.placeArch(mains, 2, random, level, decorations, origin);
        this.placeMagniaSprouts(decorations, random, level);
        return true;
    }

    private void calculateArch(RandomSource random, BlockPos origin, WorldGenLevel level, Set<BlockPos> mains, int maxDistance) {
        int windDirection = random.nextBoolean() ? -1 : 1;
        boolean weirdShape = random.nextInt(3) == 0;
        for (float angle = 0.0f; angle < (float)Math.PI * 2; angle += 0.1f) {
            BlockPos pos = BlockPos.containing((double)((float)origin.getX() + (float)windDirection * Mth.sin((float)angle) * (float)maxDistance), (double)((float)origin.getY() + Mth.cos((float)angle) * 2.0f * (float)maxDistance), (double)((float)origin.getZ() - (weirdShape ? Mth.cos((float)angle) : Mth.sin((float)angle)) * (float)maxDistance)).below(angle > -2.0f && angle <= 2.0f && maxDistance > 4 ? 4 : 0);
            if (!level.getBlockState(pos).canBeReplaced()) continue;
            mains.add(pos);
        }
    }

    private void placeArch(Set<BlockPos> mains, int radius, RandomSource random, WorldGenLevel level, Set<BlockPos> decorations, BlockPos origin) {
        mains.forEach(mainPos -> {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = mainPos.offset(x, y, z);
                        if (x * x + y * y + z * z > UniformInt.of((int)radius, (int)(radius * radius)).sample(random) || !level.getBlockState(pos).canBeReplaced()) continue;
                        level.setBlock(pos, EnderscapeBlocks.ALLURING_MAGNIA.get().defaultBlockState(), radius);
                        decorations.add(pos);
                        this.tryReplaceFloor(level, pos, random);
                    }
                }
            }
        });
    }

    private void placeMagniaSprouts(Set<BlockPos> decorations, RandomSource random, WorldGenLevel level) {
        decorations.forEach(pos -> {
            for (Direction dir : Direction.values()) {
                if (random.nextInt(15) != 0 || !level.getBlockState(pos).is(EnderscapeBlocks.ALLURING_MAGNIA.get()) || !level.getBlockState(pos.relative(dir)).canBeReplaced()) continue;
                level.setBlock(pos.relative(dir), (BlockState)EnderscapeBlocks.ALLURING_MAGNIA_SPROUT.get().defaultBlockState().setValue((Property)MagniaSproutBlock.FACING, (Comparable)dir), 2);
            }
        });
    }

    private void tryReplaceFloor(WorldGenLevel level, BlockPos origin, RandomSource random) {
        float radius = Mth.randomBetween((RandomSource)random, (float)3.0f, (float)6.0f);
        for (float y = -radius; y <= radius; y += 1.0f) {
            for (float x = -radius; x <= radius; x += 1.0f) {
                for (float z = -radius; z <= radius; z += 1.0f) {
                    BlockPos offset = origin.offset((int)x, (int)y, (int)z);
                    float distance = (float)Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= radius + Mth.nextFloat((RandomSource)random, (float)-2.5f, (float)0.5f)) || !level.getBlockState(offset).is(EnderscapeBlockTags.MAGNIA_ARCH_REPLACEABLE)) continue;
                    level.setBlock(offset, EnderscapeBlocks.ALLURING_MAGNIA.get().defaultBlockState(), 2);
                }
            }
        }
    }
}

