/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import com.mojang.serialization.Codec;
import net.bunten.enderscape.block.VeiledLeafPileBlock;
import net.bunten.enderscape.feature.VeiledLeafPileConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.joml.SimplexNoise;

public class VeiledLeafPileFeature
extends Feature<VeiledLeafPileConfig> {
    public VeiledLeafPileFeature(Codec<VeiledLeafPileConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<VeiledLeafPileConfig> context) {
        VeiledLeafPileConfig config = (VeiledLeafPileConfig)context.config();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        boolean result = false;
        float radius = config.radius().sample(random);
        float noiseScale = 0.1f;
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                BlockPos offset = context.origin().offset((int)x, 0, (int)z);
                float noiseValue = SimplexNoise.noise((float)(x * noiseScale), (float)(z * noiseScale));
                float distance = (float)Math.sqrt(x * x + z * z);
                if (!(distance <= radius * (0.8f + noiseValue * 0.4f)) || !(random.nextFloat() > config.density().sample(random))) continue;
                BlockPos.MutableBlockPos mutable = offset.above(3).mutable();
                for (int i = 0; i < 6; ++i) {
                    Block block = EnderscapeBlocks.VEILED_LEAF_PILE.get();
                    if (level.isEmptyBlock((BlockPos)mutable) && level.isEmptyBlock(mutable.above()) && VeiledLeafPileBlock.canSurvive((LevelReader)level, (BlockPos)mutable, block)) {
                        level.setBlock((BlockPos)mutable, (BlockState)block.defaultBlockState().setValue((Property)VeiledLeafPileBlock.LAYERS, (Comparable)Integer.valueOf(config.layers().sample(random))), 2);
                        result = true;
                    }
                    mutable.move(Direction.DOWN);
                }
            }
        }
        return result;
    }
}

