/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.bunten.enderscape.feature.VoidShaleConfig;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import org.joml.SimplexNoise;

public class VoidShaleFeature
extends Feature<VoidShaleConfig> {
    public static final int RADIUS = 8;
    public static final int HEIGHT = 3;

    public VoidShaleFeature(Codec<VoidShaleConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<VoidShaleConfig> context) {
        VoidShaleConfig config = (VoidShaleConfig)context.config();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        boolean bl = false;
        Optional closest = BlockPos.findClosestMatch((BlockPos)context.origin(), (int)4, (int)32, pos -> VoidShaleFeature.passesExtraConditions((LevelAccessor)level, pos, config.maxTerrainDepth().sample(random)));
        if (closest.isPresent()) {
            BlockPos center = (BlockPos)closest.get();
            for (OreConfiguration.TargetBlockState target : config.targets()) {
                if (!target.target.test(level.getBlockState(center), random)) continue;
                for (float x = -8.0f; x <= 8.0f; x += 1.0f) {
                    for (float z = -8.0f; z <= 8.0f; z += 1.0f) {
                        BlockPos offset = context.origin().offset((int)x, 0, (int)z);
                        float noiseValue = SimplexNoise.noise((float)(x * 0.1f), (float)(z * 0.1f));
                        float distance = (float)Math.sqrt(x * x + z * z);
                        if (!(distance <= 8.0f * (0.8f + noiseValue * 0.4f))) continue;
                        BlockPos.MutableBlockPos mutable = offset.above(3).mutable();
                        for (int i = 0; i < 6; ++i) {
                            BlockState replaced = level.getBlockState((BlockPos)mutable);
                            if (target.target.test(replaced, random)) {
                                level.setBlock((BlockPos)mutable, target.state, 2);
                                bl = true;
                            }
                            mutable.move(Direction.DOWN);
                        }
                    }
                }
            }
        }
        return bl;
    }

    public static boolean passesExtraConditions(LevelAccessor level, BlockPos pos, int maxDepth) {
        if (!level.getBlockState(pos).is(EnderscapeBlockTags.ORE_REPLACEABLE)) {
            return false;
        }
        if (!level.isEmptyBlock(pos.above())) {
            return false;
        }
        return VoidShaleFeature.isWithinMaxDepth(level, pos, maxDepth) && VoidShaleFeature.countValidBlocks(level, pos);
    }

    public static boolean countValidBlocks(LevelAccessor level, BlockPos pos) {
        int count = 0;
        for (int y = -3; y <= 3; ++y) {
            for (int x = -8; x <= 8; ++x) {
                for (int z = -8; z <= 8; ++z) {
                    BlockPos offset = pos.offset(x, y, z);
                    if (!level.getBlockState(offset).is(EnderscapeBlockTags.ORE_REPLACEABLE)) continue;
                    ++count;
                }
            }
        }
        return count > 20;
    }

    public static boolean isWithinMaxDepth(LevelAccessor level, BlockPos pos, int maxDepth) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int i = 0; i < maxDepth; ++i) {
            mutable.move(Direction.DOWN);
            if (!level.getBlockState((BlockPos)mutable).isAir()) continue;
            return true;
        }
        return false;
    }
}

