/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature.generator;

import net.bunten.enderscape.block.AbstractVineBlock;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.feature.LargeCelestialChanterelleConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class LargeCelestialChanterelleGenerator {
    public static final WeightedStateProvider FLANGER_BERRIES = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)EnderscapeBlocks.FLANGER_BERRY_FLOWER.get().defaultBlockState(), 1).add((Object)EnderscapeBlocks.UNRIPE_FLANGER_BERRY_BLOCK.get().defaultBlockState(), 1).add((Object)EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK.get().defaultBlockState(), 1));

    public static boolean tryGenerate(LevelAccessor level, BlockPos origin, RandomSource random, LargeCelestialChanterelleConfig config) {
        Direction direction = Direction.UP;
        BlockPos attached = origin.relative(direction.getOpposite());
        if (level.getBlockState(attached).isFaceSturdy((BlockGetter)level, attached, direction)) {
            for (int i = 0; i < config.tries(); ++i) {
                int radius;
                int height = config.height().sample(random);
                if (!LargeCelestialChanterelleGenerator.isEnoughAir(level, origin, height, (radius = (int)((float)height / config.cap_radius_division())) / 2)) continue;
                LargeCelestialChanterelleGenerator.generate(level, origin, random, config, height, radius);
                return true;
            }
        }
        return false;
    }

    public static void generate(LevelAccessor level, BlockPos pos, RandomSource random, LargeCelestialChanterelleConfig config, int height, int radius) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
        BlockUtil.place(level, pos.below(), Blocks.END_STONE.defaultBlockState());
        LargeCelestialChanterelleGenerator.generateCap(level, random, pos.above(height), config, radius);
        for (int i = 0; i < height; ++i) {
            BlockUtil.place(level, pos.above(i), EnderscapeBlocks.CELESTIAL_STEM.get().defaultBlockState());
        }
    }

    public static boolean isEnoughAir(LevelAccessor level, BlockPos pos, int height, int radius) {
        for (int i = 1; i < height + 1; ++i) {
            if (level.isEmptyBlock(pos.above(i))) continue;
            return false;
        }
        return true;
    }

    protected static void generateVines(LevelAccessor level, RandomSource random, BlockPos origin, LargeCelestialChanterelleConfig config, int radius) {
        int generatedVines = 0;
        int maxTries = config.vine_generation_tries();
        int maxRadius = (int)((float)radius * 0.8f);
        int minHeight = (int)((float)radius * 0.4f);
        for (int i = 0; i < maxTries; ++i) {
            BlockPos pos = BlockUtil.random(origin, random, maxRadius, 0, maxRadius).below(Mth.nextInt((RandomSource)random, (int)0, (int)minHeight));
            for (int offset = -4; offset < 4; ++offset) {
                BlockPos testPos = pos.above(offset);
                if (!level.getBlockState(testPos).isAir() || !level.getBlockState(testPos.above()).is(EnderscapeBlockTags.FLANGER_BERRY_VINE_PLANTABLE_ON)) continue;
                pos = testPos;
                break;
            }
            if (pos.closerThan((Vec3i)origin, (double)((int)((float)radius * 0.6f))) || generatedVines > radius / 4 && random.nextFloat() <= config.excess_vine_discard_chance() || !LargeCelestialChanterelleGenerator.canVineGrow(level, pos)) continue;
            LargeCelestialChanterelleGenerator.generateVine(level, random, pos, radius);
            ++generatedVines;
        }
    }

    private static boolean canVineGrow(LevelAccessor level, BlockPos pos) {
        return level.isEmptyBlock(pos) && level.isEmptyBlock(pos.below()) && level.getBlockState(pos.above()).is(EnderscapeBlockTags.FLANGER_BERRY_VINE_PLANTABLE_ON);
    }

    private static void generateVine(LevelAccessor level, RandomSource random, BlockPos start, int radius) {
        int length = Mth.nextInt((RandomSource)random, (int)((int)((float)radius * 0.8f)), (int)(radius * 2));
        BlockPos.MutableBlockPos mutable = start.mutable();
        for (int i = 0; i <= length; ++i) {
            if (!level.isEmptyBlock((BlockPos)mutable)) continue;
            if (i == length || !level.isEmptyBlock(mutable.below())) {
                BlockUtil.replace(level, (BlockPos)mutable, FLANGER_BERRIES.getState(random, (BlockPos)mutable));
                break;
            }
            BlockUtil.replace(level, (BlockPos)mutable, (BlockState)((BlockState)EnderscapeBlocks.FLANGER_BERRY_VINE.get().defaultBlockState().setValue((Property)StateProperties.ATTACHED, (Comparable)Boolean.valueOf(true))).setValue((Property)AbstractVineBlock.AGE, (Comparable)Integer.valueOf(15)));
            mutable.move(Direction.DOWN);
        }
    }

    protected static void generateCap(LevelAccessor level, RandomSource random, BlockPos pos, LargeCelestialChanterelleConfig config, int radius) {
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)radius)) continue;
                for (int capOrder = 1; capOrder < radius; ++capOrder) {
                    int droopAmount = distance >= (double)((float)radius * config.cap_droop_percentage()) && capOrder == 1 && radius > 3 ? 1 : 0;
                    BlockUtil.replace(level, pos.offset(x / capOrder, -(2 * capOrder + droopAmount) + 2, z / capOrder), EnderscapeBlocks.CELESTIAL_CAP.get().defaultBlockState());
                }
            }
        }
        LargeCelestialChanterelleGenerator.generateVines(level, random, pos.below(), config, radius);
    }
}

