/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature.generator;

import net.bunten.enderscape.block.MurublightShelfBlock;
import net.bunten.enderscape.feature.LargeMurublightChanterelleConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LargeMurublightChanterelleGenerator {
    public static boolean tryGenerate(LevelAccessor level, RandomSource random, BlockPos origin, LargeMurublightChanterelleConfig config) {
        Direction direction = config.direction();
        if (direction.getAxis() != Direction.Axis.Y) {
            throw new IllegalStateException("Cannot use direction " + direction.getName() + " for " + String.valueOf(LargeMurublightChanterelleConfig.class));
        }
        BlockPos attached = origin.relative(direction.getOpposite());
        if (level.getBlockState(attached).isFaceSturdy((BlockGetter)level, attached, direction)) {
            for (int i = 0; i < config.tries(); ++i) {
                int height = config.height().sample(random);
                if (!LargeMurublightChanterelleGenerator.isEnoughAir(level, origin, direction, height)) continue;
                return LargeMurublightChanterelleGenerator.generate(level, origin, random, config, height);
            }
        }
        return false;
    }

    public static boolean generate(LevelAccessor level, BlockPos origin, RandomSource random, LargeMurublightChanterelleConfig config, int height) {
        Direction direction = config.direction();
        if (level.getBlockState(origin.relative(direction.getOpposite())).is(EnderscapeBlocks.CORRUPT_OVERGROWTH.get())) {
            BlockUtil.place(level, origin.relative(direction.getOpposite()), EnderscapeBlocks.MIRESTONE.get().defaultBlockState());
        }
        BlockUtil.place(level, origin, Blocks.AIR.defaultBlockState());
        LargeMurublightChanterelleGenerator.generateCap(level, origin.relative(direction, --height), direction, config.cap_radius().sample(random), 1.0f);
        LargeMurublightChanterelleGenerator.generateMiniCaps(level, origin, random, config, height);
        for (int a = 0; a < height; ++a) {
            BlockUtil.place(level, origin.relative(direction, a), (BlockState)EnderscapeBlocks.MURUBLIGHT_STEM.get().defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
        }
        for (int b = 0; b < height; ++b) {
            if (b % 4 != 0 || b <= 0) continue;
            LargeMurublightChanterelleGenerator.generateMurublightShelves(level, origin.relative(direction, b), random, config);
        }
        return true;
    }

    protected static void generateCap(LevelAccessor level, BlockPos pos, Direction direction, int radius, float rounding) {
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)((float)radius * rounding))) continue;
                int y = direction.getAxis() != Direction.Axis.Y ? 1 : 0;
                int offset = 0;
                if (radius > 4 && distance >= (double)((float)radius * 0.3f)) {
                    ++offset;
                }
                if (radius > 3 && distance >= (double)((float)radius * 0.7f)) {
                    ++offset;
                }
                BlockPos pos2 = pos.offset(x, y, z).relative(direction, -offset);
                BlockUtil.replace(level, pos2, EnderscapeBlocks.MURUBLIGHT_CAP.get().defaultBlockState());
            }
        }
    }

    protected static void generateMiniCaps(LevelAccessor level, BlockPos pos, RandomSource random, LargeMurublightChanterelleConfig config, int height) {
        Direction direction = config.direction();
        BlockPos.MutableBlockPos mutable = pos.mutable().move(direction.getOpposite());
        int lastX = 0;
        int lastZ = 0;
        block0: for (int i = 0; i < height / 4; ++i) {
            mutable.move(direction, 4);
            for (int e = 0; e < 8; ++e) {
                int x = Mth.nextInt((RandomSource)random, (int)-1, (int)1);
                int z = Mth.nextInt((RandomSource)random, (int)-1, (int)1);
                if (x == 0 || z == 0 || x == lastX && z == lastZ) continue;
                LargeMurublightChanterelleGenerator.generateCap(level, mutable.offset(x, 0, z), direction, 3, 0.7f);
                lastX = x;
                lastZ = z;
                continue block0;
            }
        }
    }

    protected static void generateMurublightShelves(LevelAccessor level, BlockPos pos, RandomSource random, LargeMurublightChanterelleConfig config) {
        Direction direction = config.direction();
        for (Direction dir2 : Direction.values()) {
            if (dir2.getAxis() == direction.getAxis()) continue;
            for (int i = -2; i < 2; ++i) {
                BlockPos pos2 = pos.relative(dir2).offset(0, i, 0);
                BlockState state = (BlockState)EnderscapeBlocks.MURUBLIGHT_SHELF.get().defaultBlockState().setValue((Property)MurublightShelfBlock.FACING, (Comparable)dir2);
                if (!state.canSurvive((LevelReader)level, pos2) || !level.isEmptyBlock(pos2) || !(random.nextFloat() >= 0.45f)) continue;
                BlockUtil.replace(level, pos2, state);
            }
        }
    }

    public static boolean isEnoughAir(LevelAccessor level, BlockPos start, Direction direction, int height) {
        for (int i = 1; i < height + 1; ++i) {
            if (level.isEmptyBlock(start.relative(direction, i))) continue;
            return false;
        }
        return height % 4 == 0;
    }
}

