/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature.generator;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.block.VeiledLeafPileBlock;
import net.bunten.enderscape.block.VeiledLeavesBlock;
import net.bunten.enderscape.block.VeiledVinesBlock;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.feature.GrowthConfig;
import net.bunten.enderscape.feature.VeiledLeafPileConfig;
import net.bunten.enderscape.feature.VeiledTreeConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.SimplexNoise;

public class VeiledTreeGenerator {
    public static final Block LEAVES = EnderscapeBlocks.VEILED_LEAVES.get();
    public static final Block LOG = EnderscapeBlocks.VEILED_LOG.get();

    public static boolean tryGenerate(LevelAccessor level, RandomSource random, BlockPos origin, VeiledTreeConfig config) {
        if (level.getBlockState(origin.below()).isSolidRender((BlockGetter)level, origin.below()) && BlockUtil.hasTerrainDepth(level, origin.below(), 8, Direction.DOWN)) {
            int heightOffset = Mth.nextInt((RandomSource)random, (int)0, (int)2);
            VeiledTreeGenerator.generateLogs(level, origin.above(heightOffset), random, config);
            for (Direction dir : Direction.values()) {
                if (dir.getAxis() == Direction.Axis.Y) continue;
                VeiledTreeGenerator.setLeaves(level, origin.above(heightOffset).relative(dir));
            }
            VeiledTreeGenerator.generateLeaves(level, origin.above(heightOffset + 1), random, config);
            if (config.leafPileConfig().isPresent()) {
                VeiledTreeGenerator.generateLeafPiles(level, origin, random, config.leafPileConfig().get());
            }
            return true;
        }
        return false;
    }

    private static void generateLogs(LevelAccessor level, BlockPos pos, RandomSource random, VeiledTreeConfig config) {
        int i;
        BlockPos.MutableBlockPos mutable = pos.above().mutable();
        for (i = 0; i < config.log_height().sample(random); ++i) {
            VeiledTreeGenerator.setLog(level, (BlockPos)mutable);
            mutable.move(Direction.DOWN);
        }
        for (i = 0; i < config.branch_count().sample(random); ++i) {
            VeiledTreeGenerator.generateBranch(level, mutable.mutable(), random, config);
        }
    }

    private static void generateBranch(LevelAccessor level, BlockPos.MutableBlockPos mutable, RandomSource random, VeiledTreeConfig config) {
        for (int i = 0; i < config.branch_segments().sample(random) * random.nextInt(1, 2); ++i) {
            int x = (int)((float)(Mth.nextInt((RandomSource)random, (int)3, (int)4) * (random.nextBoolean() ? 1 : -1)) * VeiledTreeGenerator.calculateHorizontalFactor(random, i));
            int y = (int)((float)Mth.nextInt((RandomSource)random, (int)-4, (int)-6) * VeiledTreeGenerator.calculateVerticalFactor(random, i));
            int z = (int)((float)(Mth.nextInt((RandomSource)random, (int)3, (int)4) * (random.nextBoolean() ? 1 : -1)) * VeiledTreeGenerator.calculateHorizontalFactor(random, i));
            BlockPos end = mutable.offset(x, y, z);
            for (int o = 0; o <= 20; ++o) {
                double t = (double)o / 20.0;
                int x1 = (int)Mth.lerp((double)t, (double)mutable.getX(), (double)end.getX());
                int y1 = (int)Mth.lerp((double)t, (double)mutable.getY(), (double)end.getY());
                int z1 = (int)Mth.lerp((double)t, (double)mutable.getZ(), (double)end.getZ());
                BlockPos current = new BlockPos(x1, y1, z1);
                VeiledTreeGenerator.setLog(level, current);
            }
            mutable.move(x, y, z);
        }
    }

    private static void generateLeaves(LevelAccessor level, BlockPos origin, RandomSource random, VeiledTreeConfig config) {
        ArrayList<BlockPos> leavesBlocks = new ArrayList<BlockPos>();
        int radius = config.leaf_radius().sample(random);
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                float distance = (float)Math.sqrt(x * x + z * z);
                if (!(distance <= (float)radius)) continue;
                int yOffset = (int)(Math.pow(distance, 2.0) * (double)0.1f);
                BlockPos offset = origin.offset(x, yOffset, z);
                if (VeiledTreeGenerator.setLeaves(level, offset)) {
                    leavesBlocks.add(offset);
                }
                if (VeiledTreeGenerator.setLeaves(level, offset.above())) {
                    leavesBlocks.add(offset.above());
                }
                if (!(distance >= (float)radius * 0.8f)) continue;
                for (int i = 1; i <= random.nextInt(3); ++i) {
                    if (VeiledTreeGenerator.setLeaves(level, offset.above(i))) {
                        leavesBlocks.add(offset.above(i));
                    }
                    if (!VeiledTreeGenerator.setLeaves(level, offset.above(i + 1))) continue;
                    leavesBlocks.add(offset.above(i + 1));
                }
            }
        }
        if (!leavesBlocks.isEmpty() && config.vineConfig().isPresent()) {
            VeiledTreeGenerator.generateVines(level, leavesBlocks, random, config);
        }
    }

    private static void generateVines(LevelAccessor level, List<BlockPos> leaves, RandomSource random, VeiledTreeConfig config) {
        GrowthConfig vineConfig = config.vineConfig().get();
        BlockState state = vineConfig.state();
        for (BlockPos pos2 : leaves.stream().filter(pos -> level.isEmptyBlock(pos.above())).toList()) {
            Direction direction;
            BlockPos offset;
            if (random.nextFloat() > config.vine_generation_chance().sample(random) || !level.isEmptyBlock(offset = pos2.relative(direction = (Direction)state.getValue((Property)StateProperties.FACING))) || !state.canSurvive((LevelReader)level, offset)) continue;
            VeiledVinesBlock.generate(level, offset, random, vineConfig);
        }
    }

    private static void generateLeafPiles(LevelAccessor level, BlockPos origin, RandomSource random, VeiledLeafPileConfig config) {
        float radius = config.radius().sample(random);
        float noiseScale = 0.1f;
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                BlockPos offset = origin.offset((int)x, 0, (int)z);
                float noiseValue = SimplexNoise.noise((float)(x * noiseScale), (float)(z * noiseScale));
                float distance = (float)Math.sqrt(x * x + z * z);
                if (!(distance <= radius * (0.8f + noiseValue * 0.4f)) || !(random.nextFloat() > config.density().sample(random))) continue;
                BlockPos.MutableBlockPos mutable = offset.above(3).mutable();
                for (int i = 0; i < 6; ++i) {
                    Block block = EnderscapeBlocks.VEILED_LEAF_PILE.get();
                    if (level.isEmptyBlock((BlockPos)mutable) && level.isEmptyBlock(mutable.above()) && VeiledLeafPileBlock.canSurvive((LevelReader)level, (BlockPos)mutable, block)) {
                        level.setBlock((BlockPos)mutable, (BlockState)block.defaultBlockState().setValue((Property)VeiledLeafPileBlock.LAYERS, (Comparable)Integer.valueOf(config.layers().sample(random))), 2);
                    }
                    mutable.move(Direction.DOWN);
                }
            }
        }
    }

    private static boolean setLeaves(LevelAccessor level, BlockPos pos) {
        return BlockUtil.replace(level, pos, (BlockState)LEAVES.defaultBlockState().setValue((Property)VeiledLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
    }

    private static boolean setLog(LevelAccessor level, BlockPos pos) {
        return BlockUtil.place(level, pos, LOG.defaultBlockState());
    }

    private static float calculateVerticalFactor(RandomSource random, int g) {
        return g % 2 == 0 ? Mth.nextFloat((RandomSource)random, (float)0.8f, (float)1.2f) : Mth.nextFloat((RandomSource)random, (float)0.4f, (float)0.6f);
    }

    private static float calculateHorizontalFactor(RandomSource random, int index) {
        return index % 2 == 0 ? Mth.nextFloat((RandomSource)random, (float)0.5f, (float)0.6f) : Mth.nextFloat((RandomSource)random, (float)0.9f, (float)1.2f);
    }
}

