/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class CrackedMirrorItem
extends Item {
    public CrackedMirrorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        player.playSound(EnderscapeItemSounds.CRACKED_MIRROR_TRY_TELEPORT.get(), 1.0f, 1.0f);
        player.displayClientMessage((Component)Component.translatable((String)"item.enderscape.cracked_mirror.message.try_use").withStyle(ChatFormatting.RED), true);
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        player.getCooldowns().addCooldown((Item)this, 20);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState state = world.getBlockState(pos = context.getClickedPos());
        if (state.is(Blocks.LODESTONE)) {
            Player player = context.getPlayer();
            player.playSound(EnderscapeItemSounds.CRACKED_MIRROR_TRY_LINK.get(), 1.0f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"item.enderscape.cracked_mirror.message.try_link").withStyle(ChatFormatting.RED), true);
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

