/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DriftJellyBottleItem
extends Item {
    public DriftJellyBottleItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        ServerPlayer player;
        super.finishUsingItem(stack, level, user);
        user.playSound((SoundEvent)EnderscapeItemSounds.DRIFT_JELLY_BOTTLE_FINISH.value(), 1.0f, 1.0f);
        if (user instanceof ServerPlayer) {
            player = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (user instanceof Player && !(player = (Player)user).hasInfiniteMaterials()) {
            ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            if (!player.getInventory().add(bottle)) {
                player.drop(bottle, false);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 40;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return (SoundEvent)EnderscapeItemSounds.DRIFT_JELLY_BOTTLE_DRINK.value();
    }

    public SoundEvent getEatingSound() {
        return (SoundEvent)EnderscapeItemSounds.DRIFT_JELLY_BOTTLE_DRINK.value();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }
}

