/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.function.Predicate;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class MagniaAttractorItem
extends NebuliteToolItem {
    public MagniaAttractorItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean displayHudWhen(NebuliteToolContext context) {
        return MagniaAttractorItem.is(context.stack()) && MagniaAttractorItem.fuelExceedsCost(context) && MagniaAttractorItem.isEnabled(context.stack());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.tryCyclePower(new NebuliteToolContext(player.getItemInHand(hand), level, (LivingEntity)player)) ? InteractionResultHolder.consume((Object)player.getItemInHand(hand)) : super.use(level, player, hand);
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && other.isEmpty()) {
            return this.tryCyclePower(new NebuliteToolContext(stack, player.level(), (LivingEntity)player));
        }
        return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    private boolean tryCyclePower(NebuliteToolContext context) {
        if (MagniaAttractorItem.fuelExceedsCost(context)) {
            ItemStack stack;
            MagniaAttractorItem.setEnabled(stack, !MagniaAttractorItem.isEnabled(stack = context.stack()));
            context.user().playSound(MagniaAttractorItem.isEnabled(stack) ? EnderscapeItemSounds.MAGNIA_ATTRACTOR_POWER_ON.get() : EnderscapeItemSounds.MAGNIA_ATTRACTOR_POWER_OFF.get(), 1.0f, 1.0f);
            context.user().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            return true;
        }
        return false;
    }

    public static boolean is(ItemStack stack) {
        return stack.getItem() instanceof MagniaAttractorItem;
    }

    public static ItemStack getValidAttractor(Inventory inventory) {
        Player player = inventory.player;
        Level level = player.level();
        Predicate<ItemStack> isValidAttractor = stack -> stack.getItem() instanceof MagniaAttractorItem && NebuliteToolItem.fuelExceedsCost(new NebuliteToolContext((ItemStack)stack, level, (LivingEntity)player));
        if (isValidAttractor.test(player.getMainHandItem())) {
            return player.getMainHandItem();
        }
        if (isValidAttractor.test(player.getOffhandItem())) {
            return player.getOffhandItem();
        }
        return inventory.items.stream().filter(isValidAttractor).findFirst().orElse(ItemStack.EMPTY);
    }

    public static void setEnabled(ItemStack stack, boolean value) {
        stack.set(EnderscapeDataComponents.ENABLED, (Object)value);
    }

    public static boolean isEnabled(ItemStack stack) {
        if (stack.has(EnderscapeDataComponents.ENABLED)) {
            return (Boolean)stack.get(EnderscapeDataComponents.ENABLED);
        }
        throw new IllegalStateException(String.valueOf(stack.getItem()) + " missing component of " + String.valueOf(EnderscapeDataComponents.ENABLED));
    }

    public static void setEntitiesPulled(ItemStack stack, int value) {
        stack.set(EnderscapeDataComponents.ENTITIES_PULLED, (Object)value);
    }

    public static void incrementEntitiesPulled(ItemStack stack, int count) {
        stack.set(EnderscapeDataComponents.ENTITIES_PULLED, (Object)(MagniaAttractorItem.getEntitiesPulled(stack) + count));
    }

    public static int getEntitiesPulled(ItemStack stack) {
        if (stack.has(EnderscapeDataComponents.ENTITIES_PULLED)) {
            return (Integer)stack.get(EnderscapeDataComponents.ENTITIES_PULLED);
        }
        return 0;
    }

    public static void setEntitiesPulledToUseFuel(ItemStack stack, int value) {
        stack.set(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL, (Object)value);
    }

    public static int getEntitiesPulledToUseFuel(ItemStack stack) {
        if (stack.has(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL)) {
            return (Integer)stack.get(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL);
        }
        throw new IllegalStateException(String.valueOf(stack.getItem()) + " missing component of " + String.valueOf(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL));
    }

    public static int getEntityPullRange(ItemStack stack) {
        if (stack.has(EnderscapeDataComponents.ENTITY_PULL_RANGE)) {
            return (Integer)stack.get(EnderscapeDataComponents.ENTITY_PULL_RANGE);
        }
        return 0;
    }

    public static boolean shouldReduceFuel(ItemStack stack) {
        return MagniaAttractorItem.getEntitiesPulled(stack) >= MagniaAttractorItem.getEntitiesPulledToUseFuel(stack);
    }

    public static boolean tryUseFuel(NebuliteToolContext context, int count) {
        ItemStack stack = context.stack();
        LivingEntity user = context.user();
        if (MagniaAttractorItem.shouldReduceFuel(stack)) {
            NebuliteToolItem.useFuel(context);
            MagniaAttractorItem.setEntitiesPulled(stack, Math.max(0, count - MagniaAttractorItem.getEntitiesPulledToUseFuel(stack)));
            MagniaAttractorItem.setEnabled(stack, true);
            user.level().playSound(null, user.getX(), user.getY(), user.getZ(), EnderscapeItemSounds.MAGNIA_ATTRACTOR_USE_FUEL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

