/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.item.MirrorContext;
import net.bunten.enderscape.item.MirrorUseChecks;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.network.ClientboundTransdimensionalTravelSoundPayload;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantmentEffectComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapeServerNetworking;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableFloat;

public class MirrorItem
extends NebuliteToolItem {
    public MirrorItem(Item.Properties settings) {
        super(settings);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean bl) {
        MirrorItem.updateLodestoneTracker(stack, level);
    }

    public static void updateLodestoneTracker(ItemStack stack, Level level) {
        if (level instanceof ServerLevel) {
            LodestoneTracker ticked;
            ServerLevel server = (ServerLevel)level;
            LodestoneTracker tracker = (LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER);
            if (tracker != null && (ticked = tracker.tick(server)) != tracker) {
                stack.set(DataComponents.LODESTONE_TRACKER, (Object)ticked);
            }
        }
    }

    @Override
    public int fuelCost(NebuliteToolContext context) {
        ItemStack stack = context.stack();
        LivingEntity user = context.user();
        MirrorContext mirror = MirrorContext.of(context);
        if (mirror.dimension() != mirror.linkedDimension()) {
            return MirrorItem.maxFuel(stack);
        }
        return 1 + this.distanceBetweenPoints(user.blockPosition(), mirror.linkedPos()) / this.getTotalDistanceForCostIncrease(context);
    }

    @Override
    public boolean displayHudWhen(NebuliteToolContext context) {
        return true;
    }

    @Override
    public boolean hideInvalidOutlineWhen(NebuliteToolContext context) {
        MirrorContext mirrorContext = MirrorContext.of(context);
        boolean isLinked = MirrorItem.isLinked(context.stack());
        boolean exceedsCost = MirrorItem.fuelExceedsCost(context);
        boolean sameDimension = MirrorItem.isSameDimension(mirrorContext, mirrorContext.linkedDimension());
        boolean hasTransdimensional = MirrorItem.hasTransdimensional(mirrorContext);
        return isLinked && exceedsCost && (sameDimension || hasTransdimensional && MirrorItem.isSameCoordinateScale(mirrorContext));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        MirrorContext context = new MirrorContext(stack, world, (LivingEntity)player);
        for (MirrorUseChecks check : MirrorUseChecks.CHECKS_IN_ORDER) {
            if (!check.fails(context)) continue;
            return new InteractionResultHolder(check.getFailureResult(context), (Object)stack);
        }
        return MirrorItem.teleport(context, false) ? InteractionResultHolder.success((Object)stack) : new InteractionResultHolder(MirrorUseChecks.TELEPORT_POSITION_IS_SAFE.getFailureResult(context), (Object)stack);
    }

    public static boolean teleport(MirrorContext context, boolean fromDispenser) {
        block2: {
            Vec3 position;
            boolean sameDimension;
            GlobalPos destination;
            GlobalPos prior;
            LivingEntity user;
            block4: {
                block3: {
                    user = context.user();
                    prior = new GlobalPos(context.dimension(), user.getOnPos());
                    destination = new GlobalPos(context.linkedDimension(), context.linkedPos());
                    Optional<Vec3> optional = MirrorItem.getTeleportPosition(context);
                    sameDimension = MirrorItem.isSameDimension(context, (ResourceKey<Level>)destination.dimension());
                    if (!optional.isPresent()) break block2;
                    position = optional.get();
                    LivingEntity livingEntity = context.user();
                    if (!(livingEntity instanceof Player)) break block3;
                    Player player = (Player)livingEntity;
                    if (player.getAbilities().instabuild && !fromDispenser) break block4;
                }
                MirrorItem.useFuel(context);
            }
            MirrorItem.doPreTeleportEffects(user, !sameDimension, context, prior.pos().getCenter());
            MirrorItem.teleportToLocation(context, BlockPos.containing((Position)position), !sameDimension);
            MirrorItem.awardMirrorStatistics(context, prior, destination, fromDispenser);
            return true;
        }
        return false;
    }

    public static Optional<Vec3> getTeleportPosition(MirrorContext context) {
        Vec3 offsetPos;
        VoxelShape shape;
        LivingEntity user;
        ServerLevel level = context.linkedLevel();
        Optional freePos = level.findFreePosition((Entity)(user = context.user()), shape = Shapes.create((AABB)AABB.ofSize((Vec3)(offsetPos = context.linkedPos().above().getBottomCenter().add(0.0, (double)user.getBbHeight() / 2.0, 0.0)), (double)(user.getBbWidth() + 1.0f), (double)(user.getBbHeight() + 1.0f), (double)(user.getBbWidth() + 1.0f)).inflate(1.0E-6)), offsetPos, (double)user.getBbWidth(), (double)user.getBbHeight(), (double)user.getBbWidth());
        if (freePos.isPresent()) {
            Vec3 pos = (Vec3)freePos.get();
            BlockPos.MutableBlockPos mutable = BlockPos.containing((Position)pos).mutable();
            for (int i = 0; i < 8; ++i) {
                if (level.getBlockState(mutable.below()).isFaceSturdy((BlockGetter)level, (BlockPos)mutable, Direction.UP)) {
                    return Optional.of(Vec3.atLowerCornerOf((Vec3i)mutable));
                }
                mutable.move(Direction.DOWN);
            }
        }
        return Optional.empty();
    }

    private static void doPreTeleportEffects(LivingEntity user, boolean sameDimension, MirrorContext context, Vec3 priorVec3) {
        user.stopRiding();
        user.fallDistance = 0.0f;
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            if (user.isFallFlying()) {
                player.stopFallFlying();
            }
            EnderscapeServerNetworking.sendMirrorInfoPayload(player, sameDimension);
        }
        context.serverLevel().sendParticles((ParticleOptions)EnderscapeParticles.MIRROR_TELEPORT_OUT.get(), priorVec3.x, priorVec3.y + 0.5, priorVec3.z, 50, 0.5, 1.0, 0.5, 0.1);
    }

    private static void teleportToLocation(MirrorContext context, BlockPos destination, boolean transdimensional) {
        ServerLevel level = context.linkedLevel();
        Vec3 pos = destination.getBottomCenter();
        LivingEntity user = context.user();
        user.teleportTo(level, pos.x, pos.y, pos.z, Set.of(), 0.0f, 0.0f);
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            if (transdimensional) {
                player.connection.send((CustomPacketPayload)new ClientboundTransdimensionalTravelSoundPayload());
            }
        }
        level.sendParticles((ParticleOptions)EnderscapeParticles.MIRROR_TELEPORT_IN.get(), pos.x, pos.y + 0.5, pos.z, 50, 0.5, 1.0, 0.5, 0.1);
        level.playSound(null, pos.x, pos.y, pos.z, EnderscapeItemSounds.MIRROR_TELEPORT.get(), user.getSoundSource(), 0.65f, 1.0f);
        level.gameEvent((Holder)GameEvent.TELEPORT, user.position(), GameEvent.Context.of((Entity)user));
    }

    private static void awardMirrorStatistics(MirrorContext context, GlobalPos prior, GlobalPos destination, boolean fromDispenser) {
        LivingEntity livingEntity = context.user();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!player.getAbilities().instabuild || fromDispenser) {
                player.getCooldowns().addCooldown(context.stack().getItem(), 100);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)context.stack().getItem()));
            player.awardStat(EnderscapeStats.MIRROR_TELEPORT);
            double distance = Math.sqrt(Math.pow(destination.pos().getX() - prior.pos().getX(), 2.0) + Math.pow(destination.pos().getZ() - prior.pos().getZ(), 2.0));
            int centimeterDistance = Math.round((float)distance * 100.0f);
            if (centimeterDistance > 0) {
                player.awardStat(EnderscapeStats.MIRROR_ONE_CM, centimeterDistance);
            }
            EnderscapeCriteria.MIRROR_TELEPORT.trigger(player, context.stack(), prior, destination);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        if (state.is(Blocks.LODESTONE)) {
            MirrorItem.writeData(stack, pos, (ResourceKey<Level>)context.getLevel().dimension());
            world.playSound(null, pos, EnderscapeItemSounds.MIRROR_LINK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean isFoil(ItemStack stack) {
        return MirrorItem.wasLinkedBefore(stack) || super.isFoil(stack);
    }

    public Component getName(ItemStack stack) {
        return MirrorItem.isLinked(stack) ? Component.translatable((String)(this.getDescriptionId() + ".linked")) : super.getName(stack);
    }

    private MutableComponent tooltip(String name, Object ... objects) {
        return Component.translatable((String)("item.enderscape.mirror.desc." + name), (Object[])objects);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag flag) {
        new HoverTextHandler().appendHoverText(stack, tooltipContext, list, flag);
    }

    public static boolean is(ItemStack stack) {
        return stack.getItem() instanceof MirrorItem;
    }

    public static boolean wasLinkedBefore(ItemStack stack) {
        return stack.has(DataComponents.LODESTONE_TRACKER);
    }

    public static boolean isLinked(ItemStack stack) {
        return MirrorItem.wasLinkedBefore(stack) && ((LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER)).target().isPresent();
    }

    public static boolean isSameCoordinateScale(MirrorContext context) {
        HolderLookup.RegistryLookup registry = context.level().registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE);
        ResourceKey beginning = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)context.dimension().location());
        ResourceKey linked = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)context.linkedDimension().location());
        return DimensionType.getTeleportationScale((DimensionType)((DimensionType)((Holder.Reference)registry.get(beginning).get()).value()), (DimensionType)((DimensionType)((Holder.Reference)registry.get(linked).get()).value())) == 1.0;
    }

    public static float getAdditionalCostIncreaseDistance(ItemStack stack, LivingEntity user, float f) {
        MutableFloat mutable = new MutableFloat(f);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (holder, i) -> ((Enchantment)holder.value()).modifyUnfilteredValue(EnderscapeEnchantmentEffectComponents.MIRROR_DISTANCE_FOR_COST_INCREASE.get(), user.getRandom(), i, mutable));
        return Math.max(0.0f, mutable.floatValue());
    }

    public static void writeData(ItemStack stack, BlockPos pos, ResourceKey<Level> dimension) {
        stack.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(Optional.of(GlobalPos.of(dimension, (BlockPos)pos)), true));
    }

    public static boolean isSameDimension(MirrorContext context, ResourceKey<Level> dimension) {
        return context.dimension() == dimension;
    }

    public static boolean hasTransdimensional(MirrorContext context) {
        try {
            HolderLookup.RegistryLookup registry = context.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Optional enchantment = registry.get(EnderscapeEnchantments.TRANSDIMENSIONAL);
            return EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)enchantment.get()), (ItemStack)context.stack()) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getTotalDistanceForCostIncrease(NebuliteToolContext context) {
        ItemStack stack = context.stack();
        return (int)MirrorItem.getAdditionalCostIncreaseDistance(context.stack(), context.user(), this.getDistanceForCostIncrease(stack));
    }

    private int getDistanceForCostIncrease(ItemStack stack) {
        if (stack.has(EnderscapeDataComponents.DISTANCE_FOR_COST_TO_INCREASE)) {
            return (Integer)stack.get(EnderscapeDataComponents.DISTANCE_FOR_COST_TO_INCREASE);
        }
        throw new IllegalStateException("Cost increase distance is not defined.");
    }

    private int distanceBetweenPoints(BlockPos pos, BlockPos pos2) {
        float x = pos.getX() - pos2.getX();
        float z = pos.getZ() - pos2.getZ();
        return (int)Mth.sqrt((float)(x * x + z * z));
    }

    private class HoverTextHandler {
        private HoverTextHandler() {
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag flag) {
            Minecraft client = Minecraft.getInstance();
            EnderscapeConfig config = EnderscapeConfig.getInstance();
            MirrorContext context = new MirrorContext(stack, (Level)client.level, (LivingEntity)client.player);
            if (MirrorItem.isLinked(stack) && config.mirrorTooltipEnabled) {
                ChatFormatting typeColor = ChatFormatting.GRAY;
                ChatFormatting valueColor = ChatFormatting.BLUE;
                if (!config.mirrorTooltipShiftToDisplay || Screen.hasShiftDown()) {
                    BlockPos user = context.user().blockPosition();
                    BlockPos linkedPos = context.linkedPos();
                    ResourceKey<Level> linkedDimension = context.linkedDimension();
                    if (config.mirrorTooltipDisplayCoordinates) {
                        MutableComponent position = MirrorItem.this.tooltip("position.coordinates", linkedPos.getX(), linkedPos.getY(), linkedPos.getZ()).withStyle(valueColor);
                        MutableComponent unknown = MirrorItem.this.tooltip("position.unknown", new Object[0]).withStyle(valueColor);
                        list.add((Component)MirrorItem.this.tooltip("position", MirrorItem.isSameDimension(context, linkedDimension) ? position : unknown).withStyle(typeColor));
                    }
                    if (config.mirrorTooltipDisplayDistance) {
                        float step = (float)MirrorItem.this.getDistanceForCostIncrease(stack) / 2.0f;
                        int roundedDistance = (int)((float)Math.round((float)MirrorItem.this.distanceBetweenPoints(user, linkedPos) / step) * step);
                        MutableComponent approximate = MirrorItem.this.tooltip("distance.approximate_value", roundedDistance).withStyle(valueColor);
                        MutableComponent unknown = MirrorItem.this.tooltip("distance.unknown", new Object[0]).withStyle(valueColor);
                        list.add((Component)MirrorItem.this.tooltip("distance", MirrorItem.isSameDimension(context, linkedDimension) ? approximate : unknown).withStyle(typeColor));
                    }
                    if (config.mirrorTooltipDisplayDimension) {
                        MutableComponent dimension = Component.translatable((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)linkedDimension.location())).withStyle(valueColor);
                        list.add((Component)MirrorItem.this.tooltip("dimension", dimension).withStyle(typeColor));
                    }
                } else {
                    list.add((Component)MirrorItem.this.tooltip("unshifted", new Object[0]).withStyle(typeColor));
                }
            }
        }
    }
}

