/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.Optional;
import net.bunten.enderscape.item.NebuliteToolComponent;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.commons.lang3.math.Fraction;

public abstract class NebuliteToolItem
extends Item {
    public NebuliteToolItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public abstract boolean displayHudWhen(NebuliteToolContext var1);

    public boolean hideInvalidOutlineWhen(NebuliteToolContext context) {
        return NebuliteToolItem.fuelExceedsCost(context);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.PRIMARY && other.is(EnderscapeItems.NEBULITE.get())) {
            if (NebuliteToolItem.currentFuel(stack) < NebuliteToolItem.maxFuel(stack)) {
                NebuliteToolItem.setFuel(stack, NebuliteToolItem.currentFuel(stack) + 1);
                other.shrink(1);
                player.playSound(EnderscapeItemSounds.NEBULITE_TOOL_ADD_FUEL.get(), 1.0f, 1.0f);
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            } else {
                player.playSound(EnderscapeItemSounds.NEBULITE_TOOL_FUEL_FULL.get(), 1.0f, 1.0f);
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        boolean showTooltip = !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
        return showTooltip ? Optional.of(new NebuliteToolComponent(stack)) : Optional.empty();
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Mth.clamp((int)Mth.mulAndTruncate((Fraction)NebuliteToolItem.computeFuelAmount(stack), (int)13), (int)0, (int)13);
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF66FF;
    }

    public static boolean is(ItemStack stack) {
        return stack.getItem() instanceof NebuliteToolItem;
    }

    public static NebuliteToolItem of(ItemStack stack) {
        return NebuliteToolItem.of(stack.getItem());
    }

    public static NebuliteToolItem of(Item item) {
        return (NebuliteToolItem)item;
    }

    public static Fraction computeFuelAmount(ItemStack stack) {
        return Fraction.getFraction((int)NebuliteToolItem.currentFuel(stack), (int)NebuliteToolItem.maxFuel(stack));
    }

    public static int currentFuel(ItemStack stack) {
        return stack.has(EnderscapeDataComponents.CURRENT_NEBULITE_FUEL) ? Math.max(0, (Integer)stack.get(EnderscapeDataComponents.CURRENT_NEBULITE_FUEL)) : 0;
    }

    public static void setFuel(ItemStack stack, int value) {
        if (stack.has(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL)) {
            stack.set(EnderscapeDataComponents.CURRENT_NEBULITE_FUEL, (Object)Mth.clamp((int)value, (int)0, (int)((Integer)stack.get(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL))));
        }
    }

    public static int maxFuel(ItemStack stack) {
        if (stack.has(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL)) {
            return Math.max(0, (Integer)stack.get(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL));
        }
        throw new IllegalStateException(String.valueOf(stack.getItem()) + " missing component of " + String.valueOf(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL));
    }

    public static void setMaxFuel(ItemStack stack, int value) {
        stack.set(EnderscapeDataComponents.MAXIMUM_NEBULITE_FUEL, (Object)Math.max(0, value));
    }

    public int fuelCost(NebuliteToolContext context) {
        if (context.stack().has(EnderscapeDataComponents.NEBULITE_FUEL_PER_USE)) {
            return (Integer)context.stack().get(EnderscapeDataComponents.NEBULITE_FUEL_PER_USE);
        }
        throw new IllegalStateException(String.valueOf(context.stack().getItem()) + " missing component of " + String.valueOf(EnderscapeDataComponents.NEBULITE_FUEL_PER_USE));
    }

    public static void useFuel(NebuliteToolContext context) {
        ItemStack stack = context.stack();
        NebuliteToolItem.setFuel(stack, NebuliteToolItem.currentFuel(stack) - NebuliteToolItem.of(stack).fuelCost(context));
    }

    public static boolean fuelExceedsCost(NebuliteToolContext context) {
        ItemStack stack = context.stack();
        if (NebuliteToolItem.is(stack)) {
            return NebuliteToolItem.currentFuel(stack) >= NebuliteToolItem.of(stack).fuelCost(context);
        }
        return false;
    }
}

