/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class RustleBucketItem
extends Item
implements DispensibleContainerItem {
    private final EntityType<?> type = (EntityType)EnderscapeEntities.RUSTLE.get();

    public RustleBucketItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockPos relative;
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult result = RustleBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.success((Object)stack);
        }
        if (result.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = result.getBlockPos();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(pos.relative(result.getDirection()), result.getDirection(), stack) && this.emptyContents(player, level, relative = pos.relative(result.getDirection()), result)) {
            this.checkExtraContent(player, level, stack, relative);
            level.playSound(player, pos, EnderscapeItemSounds.RUSTLE_BUCKET_EMPTY.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)(!player.hasInfiniteMaterials() ? new ItemStack((ItemLike)Items.BUCKET) : stack)));
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Entity entity = this.type.create(server, EntityType.createDefaultStackConfig((ServerLevel)server, (ItemStack)stack, null), pos, MobSpawnType.BUCKET, true, false);
            if (entity instanceof Bucketable) {
                Bucketable bucketable = (Bucketable)entity;
                bucketable.loadFromBucketTag(((CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag());
                bucketable.setFromBucket(true);
            }
            if (entity != null) {
                server.addFreshEntityWithPassengers(entity);
            }
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
        }
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        BlockState state = level.getBlockState(pos);
        if (!state.isAir() && !state.canBeReplaced(Fluids.EMPTY)) {
            return result != null && this.emptyContents(player, level, result.getBlockPos().relative(result.getDirection()), null);
        }
        return true;
    }
}

