/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.bunten.enderscape.entity.DashJumpUser;
import net.bunten.enderscape.network.ClientboundDashJumpPayload;
import net.bunten.enderscape.network.ClientboundDashJumpSoundPayload;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public record DashJump(int dashTime, float horizontalPower, float verticalPower, float glideVelocityFactor, Holder<SoundEvent> dashSound, boolean stopUsingAfterDash) {
    public static final Codec<DashJump> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("dash_time").forGetter(DashJump::dashTime), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("horizontal_power").forGetter(DashJump::horizontalPower), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("vertical_power").forGetter(DashJump::verticalPower), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("glide_velocity_factor").forGetter(DashJump::glideVelocityFactor), (App)SoundEvent.CODEC.fieldOf("dash_sound").forGetter(DashJump::dashSound), (App)Codec.BOOL.optionalFieldOf("stop_using_after_dash", (Object)true).forGetter(DashJump::stopUsingAfterDash)).apply((Applicative)instance, DashJump::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DashJump> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DashJump::dashTime, (StreamCodec)ByteBufCodecs.FLOAT, DashJump::horizontalPower, (StreamCodec)ByteBufCodecs.FLOAT, DashJump::verticalPower, (StreamCodec)ByteBufCodecs.FLOAT, DashJump::glideVelocityFactor, (StreamCodec)SoundEvent.STREAM_CODEC, DashJump::dashSound, (StreamCodec)ByteBufCodecs.BOOL, DashJump::stopUsingAfterDash, DashJump::new);

    public boolean apply(ServerLevel level, ServerPlayer player, ItemStack stack, DashJump jump) {
        if (player.onGround() && !player.isInLiquid()) {
            Vec3 pos = player.position();
            level.sendParticles((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y + 0.5, pos.z, 5, 0.0, 0.0, 0.0, 0.1);
            stack.hurtAndBreak(player.isFallFlying() ? 9 : 3, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            for (ServerPlayer other : level.players()) {
                if (!(other.distanceToSqr(pos) < 4096.0)) continue;
                other.connection.send((CustomPacketPayload)new ClientboundDashJumpSoundPayload(player.getId(), ((SoundEvent)jump.dashSound.value()).getLocation()));
            }
            DashJumpUser.setDashed((Entity)player, true);
            DashJumpUser.setDashTicks((Entity)player, jump.dashTime());
            if (jump.stopUsingAfterDash()) {
                player.stopUsingItem();
                stack.finishUsingItem(player.level(), (LivingEntity)player);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            int cooldown = 60;
            player.getCooldowns().addCooldown(EnderscapeItems.END_STONE_RUBBLE_SHIELD.get(), cooldown);
            player.getCooldowns().addCooldown(EnderscapeItems.MIRESTONE_RUBBLE_SHIELD.get(), cooldown);
            player.getCooldowns().addCooldown(EnderscapeItems.VERADITE_RUBBLE_SHIELD.get(), cooldown);
            player.getCooldowns().addCooldown(EnderscapeItems.KURODITE_RUBBLE_SHIELD.get(), cooldown);
            player.connection.send((CustomPacketPayload)new ClientboundDashJumpPayload(this.horizontalPower, this.verticalPower, this.glideVelocityFactor));
            return true;
        }
        return false;
    }
}

