/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartMixin
extends Entity
implements MagniaMoveable {
    @Unique
    private final AbstractMinecart entity = (AbstractMinecart)this;

    @Shadow
    protected abstract void moveAlongTrack(BlockPos var1, BlockState var2);

    @Shadow
    protected abstract void comeOffTrack();

    public AbstractMinecartMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    @Unique
    public MagniaProperties createMagniaProperties() {
        return new MagniaProperties(entity -> true, entity -> Float.valueOf(0.6f), entity -> Float.valueOf(0.2f), DEFAULT_MAGNIA_PREDICATE, entity -> {
            Level patt0$temp;
            entity.setNoGravity(true);
            if (this.random.nextInt(16) == 0 && (patt0$temp = this.level()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)patt0$temp;
                server.sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.position().x, this.position().y + 0.5, this.position().z, 1, (double)0.3f, 0.3, (double)0.3f, 0.0);
            }
        }, entity -> entity.setNoGravity(false));
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void Enderscape$tick(CallbackInfo info) {
        Level level;
        if (MagniaMovingData.wasMovedByMagnia((Entity)this.entity) && (level = this.entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.comeOffTrack();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;moveAlongTrack(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    public void tick(AbstractMinecart entity, BlockPos blockPos, BlockState blockState) {
        if (!MagniaMovingData.wasMovedByMagnia((Entity)entity)) {
            this.moveAlongTrack(blockPos, blockState);
        }
    }
}

