/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntityType.class})
public abstract class BlockEntityTypeMixin {
    @Inject(method={"isValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValid(BlockState state, CallbackInfoReturnable<Boolean> info) {
        SignBlock sign;
        Block block = state.getBlock();
        if (block instanceof SignBlock && ((sign = (SignBlock)block).type().equals((Object)EnderscapeBlocks.VEILED_WOOD_TYPE) || sign.type().equals((Object)EnderscapeBlocks.CELESTIAL_WOOD_TYPE) || sign.type().equals((Object)EnderscapeBlocks.MURUBLIGHT_WOOD_TYPE))) {
            info.setReturnValue((Object)true);
        }
        if (state.getBlock() instanceof VaultBlock && state.is(EnderscapeBlocks.END_VAULT.get())) {
            info.setReturnValue((Object)true);
        }
        if (state.getBlock() instanceof TrialSpawnerBlock && state.is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            info.setReturnValue((Object)true);
        }
    }
}

