/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.List;
import net.bunten.enderscape.entity.ai.behavior.DrifterStartOrStopLeakingJelly;
import net.bunten.enderscape.entity.drifter.Drifter;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/core/dispenser/DispenseItemBehavior$14"})
public abstract class DispenseItemBehaviorMixin
extends OptionalDispenseItemBehavior {
    @Shadow
    protected abstract ItemStack takeLiquid(BlockSource var1, ItemStack var2, ItemStack var3);

    @Unique
    private boolean tryExtractDriftJelly(Level level, BlockPos pos) {
        List list = level.getEntitiesOfClass(Drifter.class, new AABB(pos), EntitySelector.NO_SPECTATORS);
        for (Drifter mob : list) {
            if (!mob.isDrippingJelly()) continue;
            mob.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            mob.playSound(EnderscapeEntitySounds.DRIFTER_MILK.get(), 0.5f, 1.0f);
            mob.setDrippingJelly(false);
            DrifterStartOrStopLeakingJelly.refreshCooldown(mob);
            return true;
        }
        return false;
    }

    @Inject(at={@At(value="HEAD")}, method={"execute"}, cancellable=true)
    private void execute(BlockSource source, ItemStack stack, CallbackInfoReturnable<ItemStack> info) {
        ServerLevel level = source.level();
        BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        if (!level.isClientSide()) {
            this.setSuccess(this.tryExtractDriftJelly((Level)level, pos));
            if (this.isSuccess()) {
                info.setReturnValue((Object)this.takeLiquid(source, stack, new ItemStack((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get())));
            }
        }
    }
}

