/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.List;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndCrystalItem.class})
public class EndCrystalItemMixin
extends Item {
    public EndCrystalItemMixin(Item.Properties settings) {
        super(settings);
    }

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> info) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState state = world.getBlockState(pos = context.getClickedPos());
        if (state.is(EnderscapeBlockTags.SUPPORTS_END_CRYSTAL) && state.isCollisionShapeFullBlock((BlockGetter)world, pos)) {
            BlockPos pos2 = pos.above();
            if (!world.isEmptyBlock(pos2)) {
                info.setReturnValue((Object)InteractionResult.FAIL);
            } else {
                double z;
                double y;
                double x = pos2.getX();
                List list = world.getEntities(null, new AABB(x, y = (double)pos2.getY(), z = (double)pos2.getZ(), x + 1.0, y + 2.0, z + 1.0));
                if (!list.isEmpty()) {
                    info.setReturnValue((Object)InteractionResult.FAIL);
                } else {
                    if (world instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)world;
                        EndCrystal crystal = new EndCrystal(world, x + 0.5, y, z + 0.5);
                        crystal.setShowBottom(false);
                        world.addFreshEntity((Entity)crystal);
                        world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos2);
                        EndDragonFight dragonFight = server.getDragonFight();
                        if (dragonFight != null) {
                            dragonFight.tryRespawn();
                        }
                    }
                    context.getItemInHand().shrink(1);
                    info.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }
}

