/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import com.mojang.serialization.Codec;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.feature.EndGatewayFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndGatewayFeature.class})
public abstract class EndGatewayFeatureMixin
extends Feature<EndGatewayConfiguration> {
    public EndGatewayFeatureMixin(Codec<EndGatewayConfiguration> codec) {
        super(codec);
    }

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    public void Enderscape$place(FeaturePlaceContext<EndGatewayConfiguration> context, CallbackInfoReturnable<Boolean> info) {
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        EndGatewayConfiguration config = (EndGatewayConfiguration)context.config();
        this.setBlock((LevelWriter)level, origin, Blocks.END_GATEWAY.defaultBlockState());
        config.getExit().ifPresent(exitPos -> {
            BlockEntity patt0$temp = level.getBlockEntity(origin);
            if (patt0$temp instanceof TheEndGatewayBlockEntity) {
                TheEndGatewayBlockEntity gateway = (TheEndGatewayBlockEntity)patt0$temp;
                gateway.setExitPosition(exitPos, config.isExitExact());
            }
        });
        this.setBlock((LevelWriter)level, origin.above(), Blocks.BEDROCK.defaultBlockState());
        this.setBlock((LevelWriter)level, origin.below(), Blocks.BEDROCK.defaultBlockState());
        for (Direction dir : Direction.values()) {
            if (dir.getAxis() == Direction.Axis.Y) continue;
            this.setBlock((LevelWriter)level, origin.above().relative(dir), (BlockState)((BlockState)((BlockState)EnderscapeBlocks.CUT_SHADOLINE_STAIRS.get().defaultBlockState().setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)dir.getOpposite()));
            this.setBlock((LevelWriter)level, origin.below().relative(dir), (BlockState)((BlockState)((BlockState)EnderscapeBlocks.CUT_SHADOLINE_STAIRS.get().defaultBlockState().setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)dir.getOpposite()));
        }
        this.setBlock((LevelWriter)level, origin.above(2), EnderscapeBlocks.CHISELED_SHADOLINE.get().defaultBlockState());
        this.setBlock((LevelWriter)level, origin.below(2), EnderscapeBlocks.CHISELED_SHADOLINE.get().defaultBlockState());
        this.setBlock((LevelWriter)level, origin.above(3), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)EnderscapeBlocks.SHADOLINE_BLOCK_WALL.get().defaultBlockState().setValue((Property)BlockStateProperties.EAST_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.NORTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.SOUTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.WEST_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.TRUE));
        this.setBlock((LevelWriter)level, origin.below(3), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)EnderscapeBlocks.SHADOLINE_BLOCK_WALL.get().defaultBlockState().setValue((Property)BlockStateProperties.EAST_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.NORTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.SOUTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.WEST_WALL, (Comparable)WallSide.NONE)).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.TRUE));
        info.setReturnValue((Object)true);
    }
}

