/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeServerNetworking;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderMan.class})
public abstract class EnderManMixin
extends Monster {
    @Unique
    private final EnderMan enderman = (EnderMan)this;

    protected EnderManMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"isLookingAtMe"}, at={@At(value="RETURN")})
    public void Enderscape$sendStarePayload(Player player, CallbackInfoReturnable<Boolean> info) {
        ServerPlayer server;
        if (((Boolean)info.getReturnValue()).booleanValue() && player instanceof ServerPlayer && this.enderman.canAttack((LivingEntity)(server = (ServerPlayer)player))) {
            EnderscapeServerNetworking.sendStareOverlayPayload(server);
        }
    }

    @Inject(method={"playStareSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void Enderscape$playStareSound(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().endermanStereoStareSound) {
            info.cancel();
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="TAIL")})
    public void Enderscape$setTarget(LivingEntity target, CallbackInfo ci) {
        ServerPlayer server;
        if (target instanceof ServerPlayer && this.enderman.canAttack((LivingEntity)(server = (ServerPlayer)target)) && EnderscapeConfig.getInstance().endermanStereoStareSound) {
            EnderscapeServerNetworking.sendStareSoundPayload(server, this.getId());
        }
    }
}

