/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements MagniaMoveable {
    @Unique
    private final ItemEntity entity = (ItemEntity)this;

    @Shadow
    public abstract ItemStack getItem();

    public ItemEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    @Unique
    public MagniaProperties createMagniaProperties() {
        return new MagniaProperties(item -> false, item -> Float.valueOf(0.6f), item -> Float.valueOf(0.8f), item -> true, item -> {
            Level patt0$temp;
            this.entity.setPickUpDelay(20);
            this.entity.setNoGravity(true);
            if (this.random.nextInt(16) == 0 && (patt0$temp = this.level()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)patt0$temp;
                server.sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.position().x, this.position().y + 0.5, this.position().z, 1, (double)0.3f, 0.3, (double)0.3f, 0.0);
            }
        }, item -> item.setNoGravity(false));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/stats/Stat;I)V", shift=At.Shift.AFTER)}, method={"playerTouch"})
    private void Enderscape$awardItemsPulledStat(Player player, CallbackInfo info) {
        if (player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            if (MagniaMovingData.wasMovedByMagnia((Entity)this.entity)) {
                server.awardStat(EnderscapeStats.ITEMS_ATTRACTED, this.getItem().getCount());
            }
        }
    }
}

