/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.entity.DashJumpUser;
import net.bunten.enderscape.entity.EndTrialSpawnable;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.item.MagniaAttractorItem;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.particle.DashJumpShockwaveParticleOptions;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeMobEffects;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.tag.EnderscapeEntityTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements MagniaMoveable,
DashJumpUser,
EndTrialSpawnable {
    @Unique
    private Vec3 Enderscape$deltaMovementAtStartOfTravel;
    @Unique
    private final LivingEntity mob = (LivingEntity)this;
    @Unique
    private int Enderscape$elytraGroundTicks = 0;

    @Shadow
    public abstract boolean isFallFlying();

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract float getYHeadRot();

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    @Unique
    public MagniaProperties createMagniaProperties() {
        return new MagniaProperties(entity -> true, entity -> Float.valueOf(entity.getType().is(EnderscapeEntityTags.AFFECTED_BY_MAGNIA) ? 0.05f : 0.01f * MagniaMoveable.getMagnetismFactor(entity)), entity -> Float.valueOf(entity.getType().is(EnderscapeEntityTags.AFFECTED_BY_MAGNIA) ? 0.05f : 0.02f * MagniaMoveable.getMagnetismFactor(entity)), DEFAULT_MAGNIA_PREDICATE, entity -> {
            Level patt0$temp;
            if (entity instanceof LivingEntity) {
                AttributeInstance gravity;
                LivingEntity living = (LivingEntity)entity;
                if (!(entity instanceof Player) && !(gravity = living.getAttribute(Attributes.GRAVITY)).hasModifier(MAGNIA_GRAVITY_MODIFIER.id())) {
                    gravity.addTransientModifier(MAGNIA_GRAVITY_MODIFIER);
                }
            }
            entity.fallDistance = 0.0f;
            if (this.random.nextInt(16) == 0 && (patt0$temp = this.level()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)patt0$temp;
                server.sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.position().x, this.position().y + 0.5, this.position().z, 1, (double)0.3f, 0.3, (double)0.3f, 0.0);
            }
        }, entity -> {
            if (entity instanceof LivingEntity) {
                AttributeInstance gravity;
                LivingEntity living = (LivingEntity)entity;
                if (!(entity instanceof Player) && (gravity = living.getAttribute(Attributes.GRAVITY)).hasModifier(MAGNIA_GRAVITY_MODIFIER.id())) {
                    gravity.removeModifier(MAGNIA_GRAVITY_MODIFIER);
                }
            }
            entity.fallDistance = 0.0f;
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"canStandOnFluid"}, cancellable=true)
    public void Enderscape$canStandOnFluid(FluidState state, CallbackInfoReturnable<Boolean> info) {
        if (this.isFallFlying() && EnderscapeEnchantments.hasRebound(this.level(), this.getItemBySlot(EquipmentSlot.CHEST)) && this.getDeltaMovement().y() > -0.9) {
            info.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V"))
    private void Enderscape$redirectShieldDamageSound(Level level, Entity entity, byte b) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getUseItem().is(EnderscapeItemTags.RUBBLE_SHIELDS)) {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), EnderscapeItemSounds.RUBBLE_SHIELD_BLOCK.get(), entity.getSoundSource(), 2.0f, 1.0f);
        } else {
            level.broadcastEntityEvent(entity, b);
        }
    }

    @Inject(method={"updateFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;elytraFlightTick(Lnet/minecraft/world/entity/LivingEntity;I)Z", shift=At.Shift.BEFORE)})
    private void Enderscape$updateFallFlying(CallbackInfo info) {
        if (this.onGround()) {
            ItemStack stack;
            if (this.Enderscape$elytraGroundTicks % 3 == 0 && this.Enderscape$elytraGroundTicks < 10 && this.mob.isFallFlying() && (stack = this.mob.getItemBySlot(EquipmentSlot.CHEST)).isDamageableItem() && stack.getDamageValue() < stack.getMaxDamage()) {
                stack.hurtAndBreak(1, this.mob, this.mob.getEquipmentSlotForItem(stack));
            }
            ++this.Enderscape$elytraGroundTicks;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"take"})
    private void Enderscape$take(Entity entity, int i, CallbackInfo ci) {
        Player player;
        ItemStack stack;
        LivingEntity livingEntity;
        if (this.isAlive() && !this.isSpectator() && MagniaMovingData.wasMovedByMagnia(entity) && (livingEntity = this.mob) instanceof Player && !(stack = MagniaAttractorItem.getValidAttractor((player = (Player)livingEntity).getInventory())).isEmpty()) {
            NebuliteToolContext context = new NebuliteToolContext(stack, this.level(), (LivingEntity)player);
            if (stack.getItem() instanceof MagniaAttractorItem && NebuliteToolItem.fuelExceedsCost(context)) {
                MagniaAttractorItem.incrementEntitiesPulled(stack, 1);
                MagniaAttractorItem.tryUseFuel(context, 1 - MagniaAttractorItem.getEntitiesPulledToUseFuel(stack));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void Enderscape$headTick(CallbackInfo info) {
        if (DashJumpUser.dashed((Entity)this.mob) && (this.onGround() || this.getVehicle() != null || this.isInLiquid() || this.isSpectator())) {
            DashJumpUser.setDashed((Entity)this.mob, false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void Enderscape$tailTick(CallbackInfo info) {
        Vec3 vel;
        if (this.Enderscape$hasDriftPhysics() && !this.Enderscape$shouldCancelDriftPhysics()) {
            vel = this.mob.getDeltaMovement();
            double maxSpeed = 2.0;
            double frictionMod = Math.min(1.0, 0.96 + Math.max(0.0, (Math.hypot(vel.x, vel.z) - maxSpeed) / maxSpeed) * 0.5);
            this.mob.setDeltaMovement(vel.x / frictionMod, vel.y, vel.z / frictionMod);
        }
        if (!this.isFallFlying() && this.Enderscape$elytraGroundTicks > 0) {
            --this.Enderscape$elytraGroundTicks;
        }
        if (DashJumpUser.dashed((Entity)this.mob)) {
            vel = this.mob.position().subtract(new Vec3(this.xOld, this.yOld, this.zOld)).scale(-1.0);
            if (this.mob.isShiftKeyDown()) {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().multiply(0.92, 1.0, 0.92));
            }
            int ticks = DashJumpUser.dashTicks((Entity)this.mob);
            double x = this.random.nextGaussian() * 0.02 + vel.x;
            double y = this.random.nextGaussian() * 0.02 + vel.y;
            double z = this.random.nextGaussian() * 0.02 + vel.z;
            if (ticks > 40 && ticks % 5 == 0 && ticks != 60) {
                this.level().addParticle((ParticleOptions)new DashJumpShockwaveParticleOptions(vel.toVector3f(), (float)ticks / 60.0f), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), vel.x, vel.y, vel.z);
            }
            this.level().addParticle((ParticleOptions)EnderscapeParticles.DASH_JUMP_SPARKS.get(), this.getRandomX(1.0) - vel.x / 2.0, this.getRandomY() - vel.y / 2.0, this.getRandomZ(1.0) - vel.z / 2.0, x, y, z);
            DashJumpUser.setDashTicks((Entity)this.mob, ticks - 1);
            if (ticks <= 0 || ticks < 50 && vel.lengthSqr() < 0.6) {
                DashJumpUser.setDashed((Entity)this.mob, false);
            }
        }
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z", ordinal=1)})
    private boolean Enderscape$travel(boolean existing) {
        return EnderscapeEnchantments.hasRebound(this.level(), this.getItemBySlot(EquipmentSlot.CHEST)) ? this.Enderscape$elytraGroundTicks >= 10 && this.isFallFlying() : existing;
    }

    @ModifyExpressionValue(method={"updateFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z")})
    private boolean Enderscape$updateFallFlying(boolean existing) {
        return EnderscapeEnchantments.hasRebound(this.level(), this.getItemBySlot(EquipmentSlot.CHEST)) ? this.Enderscape$elytraGroundTicks >= 10 && this.isFallFlying() : existing;
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void Enderscape$travelHead(Vec3 vec3, CallbackInfo ci) {
        this.Enderscape$deltaMovementAtStartOfTravel = this.getDeltaMovement();
    }

    @Inject(method={"travel"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isFallFlying()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", shift=At.Shift.AFTER)})
    private void Enderscape$travelShiftAfter(Vec3 vec3, CallbackInfo ci) {
        if (this.onGround() && this.mob.getDeltaMovement().lengthSqr() > 0.4 && !EnderscapeEnchantments.hasRebound(this.level(), this.getItemBySlot(EquipmentSlot.CHEST))) {
            this.Enderscape$playLandingEffects(this.Enderscape$deltaMovementAtStartOfTravel.horizontalDistance(), this.getDeltaMovement().horizontalDistance());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"makePoofParticles"}, cancellable=true)
    public void Enderscape$makePoofParticles(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().voidPoofParticlesUponDeath && this.mob.getType().is(EnderscapeEntityTags.CREATES_VOID_PARTICLES_UPON_DEATH)) {
            info.cancel();
            for (int i = 0; i < 20; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)EnderscapeParticles.VOID_POOF.get(), this.getRandomX(1.0) - d * 10.0, this.getRandomY() - e * 10.0, this.getRandomZ(1.0) - f * 10.0, d, e, f);
            }
        }
    }

    @Unique
    private void Enderscape$playLandingEffects(double start, double last) {
        this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), EnderscapeItemSounds.ELYTRA_LAND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double difference = start - last;
            float severity = (float)(difference * 10.0 - 3.0);
            Vec3 pos = this.position();
            int count = (int)(Mth.clamp((double)(this.mob.getDeltaMovement().lengthSqr() * 40.0), (double)5.0, (double)100.0) + (double)((this.fallDistance + severity) * 5.0f));
            server.sendParticles((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y + 0.2, pos.z, count, 0.0, 0.0, 0.0, 0.3);
            server.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, pos.x, pos.y + 0.2, pos.z, 1, 0.0, 0.0, 0.0, 0.3);
        }
    }

    @Unique
    protected boolean Enderscape$hasDriftPhysics() {
        return this.mob.getItemBySlot(EquipmentSlot.LEGS).is(EnderscapeItems.DRIFT_LEGGINGS.get()) || this.mob.hasEffect(EnderscapeMobEffects.LOW_GRAVITY);
    }

    @Unique
    protected boolean Enderscape$shouldCancelDriftPhysics() {
        if (this.mob.isSpectator()) {
            return true;
        }
        if (this.mob.isShiftKeyDown()) {
            return true;
        }
        if (this.mob.onGround()) {
            return true;
        }
        if (this.mob.isFallFlying()) {
            return true;
        }
        if (this.mob.isPassenger()) {
            return true;
        }
        if (this.mob.isInWaterOrBubble()) {
            return true;
        }
        if (this.mob.hasEffect(MobEffects.LEVITATION)) {
            return true;
        }
        LivingEntity livingEntity = this.mob;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.getAbilities().flying) {
                return true;
            }
        }
        return false;
    }
}

